<?php
/**
 * Hostxolo - 404 Not Found Page
 */
require_once 'config.php';

http_response_code(404);

include 'includes/header.php';
?>

<section class="py-5" style="margin-top: 70px; min-height: 60vh;">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8 text-center">
                <div class="py-5">
                    <i class="bi bi-search text-muted" style="font-size: 6rem;"></i>
                    <h1 class="display-1 fw-bold text-primary mt-4">404</h1>
                    <h2 class="mb-3">Page Not Found</h2>
                    <p class="text-muted mb-4">The page you are looking for might have been removed, had its name changed, or is temporarily unavailable.</p>
                    <div class="d-flex justify-content-center gap-3">
                        <a href="<?php echo BASE_URL; ?>" class="btn btn-primary btn-lg">
                            <i class="bi bi-house me-2"></i>Back to Home
                        </a>
                        <a href="<?php echo BASE_URL; ?>contact.php" class="btn btn-outline-primary btn-lg">
                            <i class="bi bi-envelope me-2"></i>Contact Us
                        </a>
                    </div>
                    
                    <!-- Search Box -->
                    <div class="mt-5">
                        <p class="text-muted">Or try searching:</p>
                        <form action="<?php echo BASE_URL; ?>services.php" method="GET" class="d-flex justify-content-center">
                            <div class="input-group" style="max-width: 400px;">
                                <input type="text" name="search" class="form-control form-control-lg" placeholder="Search services...">
                                <button class="btn btn-primary" type="submit">
                                    <i class="bi bi-search"></i>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>
