# HOSTXOLO Changelog

All notable changes to the HOSTXOLO project will be documented in this file.

## [2.0.0] - 2025-02-12

### Added
- **Security Enhancements**
  - Rate limiting for login attempts with automatic account lockout
  - Password strength meter with configurable requirements
  - Secure password reset flow with token-based verification
  - Login attempt logging for security auditing
  - Session management with automatic timeout
  - IP-based blocking mechanism

- **Database Schema Upgrades**
  - `email_queue` table for queued email processing
  - `coupons` table for promo code management
  - `faqs` table for FAQ management with helpful/not helpful tracking
  - `newsletter_subscribers` table for email marketing
  - `login_attempts` table for security monitoring
  - `password_resets` table for secure token storage
  - `user_sessions` table for enhanced session management
  - `user_notifications` table for in-app notifications
  - `referrals` table for referral system
  - `payment_webhook_logs` table for payment gateway tracking
  - `export_history` table for audit trail
  - `system_settings` table for dynamic configuration

- **Admin Panel Features**
  - FAQ Management (add, edit, delete with categories)
  - Newsletter Subscriber Management with CSV export
  - Coupon/Promo Code System with usage limits and expiry
  - Team Members Management with photo uploads
  - File Manager with drag-and-drop upload
  - System Settings page for maintenance mode and feature toggles
  - Bulk actions on all CRUD tables
  - Export functionality (CSV) for all data tables

- **Configuration Enhancements**
  - Google Services integration (Analytics, Tag Manager, OAuth)
  - Facebook Login configuration
  - reCAPTCHA support
  - Feature toggles (maintenance mode, registration, social login)
  - Security settings (max login attempts, lockout duration, session timeout)
  - Marketing settings (newsletter popup, announcement bar, live chat)
  - Email queue settings
  - Voice/Telecalling API placeholders

- **Helper Functions**
  - `is_account_locked()` - Check if account is locked
  - `record_login_attempt()` - Log login attempts
  - `check_password_strength()` - Validate password strength
  - `generate_password_reset_token()` - Secure token generation
  - `verify_password_reset_token()` - Token verification
  - `queue_email()` - Add email to queue
  - `get_system_setting()` - Retrieve dynamic settings
  - `update_system_setting()` - Update dynamic settings
  - `has_permission()` - Permission checking
  - `generate_referral_code()` - Create referral codes
  - `add_notification()` - Add user notifications
  - `get_user_notifications()` - Retrieve notifications
  - `mark_notifications_read()` - Mark notifications as read
  - `export_to_csv()` - Export data to CSV
  - `validate_file_upload()` - File upload validation
  - `get_unread_notification_count()` - Get notification count

### Enhanced
- **config.php**
  - Added 50+ new configuration constants
  - Organized settings into logical groups
  - Added environment-based error handling
  - Enhanced security keys and encryption settings

- **Database Schema**
  - Added indexes for performance optimization
  - Added default system settings data
  - Enhanced existing tables with additional fields

### Security
- Implemented CSRF protection on all forms
- Added SQL injection prevention with prepared statements
- Enhanced XSS protection with output escaping
- Added rate limiting for authentication endpoints
- Implemented secure password reset workflow
- Added session security with periodic regeneration

## [1.0.0] - 2025-02-11

### Initial Release
- Core website structure with PHP and MySQL
- User registration and authentication
- Admin dashboard with basic CRUD operations
- Subscription plan management
- Services and software product catalog
- Blog system with categories
- Contact form and inquiry management
- Support ticket system
- Payment gateway placeholders (Razorpay, Stripe, PayPal)
- Email template system
- Basic SEO settings
- Responsive design with Bootstrap 5
- WhatsApp integration

---

## Versioning Convention

We use [Semantic Versioning](https://semver.org/) for version numbers:
- **MAJOR** version for incompatible API changes
- **MINOR** version for added functionality in a backwards compatible manner
- **PATCH** version for backwards compatible bug fixes

## Notes

- Update database schema by running `database.sql` after each upgrade
- Review `config.php` for new configuration options after each update
- Clear cache and session data after major updates
- Backup database before applying schema changes
