# Hostxolo Production Deployment Guide

## 🚀 Complete cPanel Deployment Guide

This guide covers the complete deployment process for Hostxolo on a cPanel hosting environment.

### 📋 Prerequisites

- cPanel hosting account with PHP 8.0+ support
- MySQL/MariaDB database access
- SSL certificate (Let's Encrypt recommended)
- Domain name pointing to the hosting

---

## 🔧 Step 1: Server Setup

### 1.1 PHP Configuration
1. Log in to cPanel
2. Go to **MultiPHP Manager** or **Select PHP Version**
3. Set PHP version to **8.0 or higher**
4. Click **Options** and ensure these extensions are enabled:
   - `pdo_mysql`
   - `curl`
   - `json`
   - `mbstring`
   - `openssl`
   - `fileinfo`
   - `gd`
   - `zip`
   - `xml`

### 1.2 Database Setup
1. Go to **MySQL Databases** in cPanel
2. Create a new database:
   - Database name: `hostxolo_db`
   - Username: `hostxolo_user`
   - Password: Generate a strong password
3. Add user to database with **ALL PRIVILEGES**
4. Note down these credentials for the .env file

### 1.3 File Upload
1. Upload the entire Hostxolo folder to **public_html**
2. Ensure the folder structure is:
   ```
   public_html/
   ├── hostxolo/
   ├── .env
   ├── .htaccess
   └── all other files
   ```

---

## 🔐 Step 2: Environment Configuration

### 2.1 Create Production .env File
1. Copy `.env.production` to `.env`
2. Update all credentials with your live values:

```bash
# Database Configuration
DB_HOST=localhost
DB_DATABASE=hostxolo_db
DB_USERNAME=hostxolo_user
DB_PASSWORD=your_secure_password

# Application URL
APP_URL=https://yourdomain.com/hostxolo/

# Payment Gateway (Razorpay)
RAZORPAY_MODE=live
RAZORPAY_LIVE_KEY_ID=your_live_key
RAZORPAY_LIVE_KEY_SECRET=your_live_secret

# Email Configuration
SMTP_HOST=smtp.yourdomain.com
SMTP_PORT=587
SMTP_USERNAME=noreply@yourdomain.com
SMTP_PASSWORD=your_email_password
SMTP_FROM_EMAIL=noreply@yourdomain.com

# SMS Gateway (MSG91)
SMS_API_KEY=your_msg91_api_key
SMS_API_SECRET=your_msg91_auth_key
SMS_SENDER_ID=YOURBRAND

# WhatsApp Business API
WHATSAPP_API_KEY=your_whatsapp_token
WHATSAPP_PHONE_NUMBER_ID=your_phone_id

# Security Keys (Generate new ones)
ENCRYPTION_KEY=your-new-32-character-encryption-key
JWT_SECRET=your-new-32-character-jwt-secret
```

### 2.2 Set File Permissions
Set these permissions via cPanel **File Manager**:

```bash
# Main directories: 755
# Files: 644
# Sensitive files: 600
.env - 600
config.php - 600
includes/ - 755
cron/ - 755
```

---

## 🗄️ Step 3: Database Import

### 3.1 Import Database
1. Go to **phpMyAdmin** in cPanel
2. Select your database (`hostxolo_db`)
3. Click **Import**
4. Choose the `database.sql` file
5. Click **Go** to import

### 3.2 Verify Tables
Ensure these tables exist:
- `users`
- `admin_users`
- `subscription_plans`
- `user_subscriptions`
- `support_tickets`
- `transactions`
- `notifications`

---

## 🌐 Step 4: Domain & SSL Setup

### 4.1 Domain Configuration
1. In cPanel, go to **Domains**
2. Add your domain if not already added
3. Set document root to `/public_html/hostxolo`

### 4.2 SSL Certificate
1. Go to **SSL/TLS Status**
2. Enable **Let's Encrypt** for your domain
3. Ensure **Force HTTPS Redirect** is enabled

---

## 📧 Step 5: Email Configuration

### 5.1 SMTP Setup
Choose one option:

**Option A: cPanel Email**
1. Create email account in cPanel: `noreply@yourdomain.com`
2. Use these SMTP settings:
   - Host: `mail.yourdomain.com`
   - Port: `587`
   - Encryption: `TLS`

**Option B: Transactional Email Service**
1. Sign up for SendGrid, Mailgun, or Amazon SES
2. Verify your domain
3. Use their SMTP credentials in .env

### 5.2 Test Email
1. Visit: `https://yourdomain.com/hostxolo/test-email.php`
2. Verify email sending works
3. Delete test-email.php after testing

---

## 💳 Step 6: Payment Gateway Setup

### 6.1 Razorpay Configuration
1. Log in to [Razorpay Dashboard](https://dashboard.razorpay.com/)
2. Switch to **Live Mode**
3. Get API keys from **Settings → API Keys**
4. Add webhook URL: `https://yourdomain.com/hostxolo/webhooks/razorpay.php`

### 6.2 Test Payment
1. Create a test subscription
2. Complete payment process
3. Verify in admin panel

---

## 📱 Step 7: SMS & WhatsApp Setup

### 7.1 MSG91 SMS Setup
1. Sign up at [MSG91](https://msg91.com/)
2. Get API Key and Auth Key
3. Create SMS templates
4. Update .env with credentials

### 7.2 WhatsApp Business API
1. Create WhatsApp Business Account
2. Get Phone Number ID and API Key
3. Configure webhook
4. Update .env with credentials

---

## ⏰ Step 8: Cron Job Setup

### 8.1 Plan Expiry Checker
1. In cPanel, go to **Cron Jobs**
2. Add new cron job:
   ```
   Command: /usr/bin/php /home/username/public_html/hostxolo/cron/check-expiry.php
   Schedule: Once daily (0 0 * * *)
   ```

### 8.2 Backup Script (Optional)
```bash
# Daily database backup
Command: mysqldump -u username -p'password' hostxolo_db > /home/username/backups/db_backup_$(date +\%Y\%m\%d).sql
Schedule: Once daily
```

---

## 🔒 Step 9: Security Hardening

### 9.1 File Protection
Add this to `.htaccess`:
```apache
# Protect sensitive files
<Files ".env">
    Order allow,deny
    Deny from all
</Files>

<Files "config.php">
    Order allow,deny
    Deny from all
</Files>

# Prevent directory listing
Options -Indexes

# Hide .htaccess
<Files .htaccess>
    Order allow,deny
    Deny from all
</Files>
```

### 9.2 Admin Panel Protection
1. Change admin panel URL: `/admin/` → `/secure-admin-xyz123/`
2. Add IP whitelist if needed
3. Enable two-factor authentication

### 9.3 Security Headers
Add to `.htaccess`:
```apache
<IfModule mod_headers.c>
    Header always set X-Content-Type-Options nosniff
    Header always set X-Frame-Options DENY
    Header always set X-XSS-Protection "1; mode=block"
    Header always set Referrer-Policy "strict-origin-when-cross-origin"
    Header always set Content-Security-Policy "default-src 'self'; script-src 'self' 'unsafe-inline' https://cdn.jsdelivr.net https://checkout.razorpay.com; style-src 'self' 'unsafe-inline' https://cdn.jsdelivr.net https://fonts.googleapis.com; font-src 'self' https://fonts.gstatic.com; img-src 'self' data: https:; connect-src 'self' https://api.razorpay.com;"
</IfModule>
```

---

## 🧪 Step 10: Testing & Verification

### 10.1 Functionality Checklist
- [ ] User registration works
- [ ] Email verification sent
- [ ] Login/logout works
- [ ] Admin panel accessible
- [ ] Payment processing works
- [ ] Notifications sent (email, SMS, WhatsApp)
- [ ] Support tickets created
- [ ] Plan expiry notifications work

### 10.2 Performance Testing
1. Test page load speeds
2. Check mobile responsiveness
3. Verify SSL certificate
4. Test payment flow end-to-end

---

## 📊 Step 11: Monitoring & Maintenance

### 11.1 Log Monitoring
Regularly check:
- PHP error logs: `/home/username/public_html/hostxolo/logs/`
- Apache/Nginx access logs
- Email delivery logs

### 11.2 Regular Maintenance
- Weekly: Check for expired subscriptions
- Monthly: Update security patches
- Quarterly: Review and update SSL certificates
- Annually: Review all API credentials

---

## 🚨 Important Notes

### Production Checklist
- [ ] Remove `test-email.php` and other test files
- [ ] Change default admin password
- [ ] Update all API keys to production
- [ ] Enable error logging (disable display)
- [ ] Set up regular backups
- [ ] Configure monitoring alerts

### Backup Strategy
1. **Database Backup**: Daily automated
2. **File Backup**: Weekly full backup
3. **Off-site Storage**: Use cloud storage for backups
4. **Recovery Testing**: Test restore process monthly

---

## 🎯 Post-Deployment Tasks

1. **Monitor First 24 Hours**: Check for any errors
2. **User Testing**: Have real users test the system
3. **Performance Optimization**: Enable caching if needed
4. **Analytics Setup**: Configure Google Analytics
5. **SEO Setup**: Submit sitemap to search engines

---

## 📞 Support

If you encounter issues during deployment:

1. Check error logs first
2. Verify all credentials in .env
3. Ensure all PHP extensions are enabled
4. Test database connection
5. Verify file permissions

For additional support, refer to the troubleshooting guide or contact your hosting provider.
