# Hostxolo - Business Consulting Website

A complete, production-ready, subscription-based business consulting website built with pure PHP, MySQL, HTML5, CSS3, JavaScript, and Bootstrap.

## Features

### Frontend
- Modern, responsive design with Bootstrap 5
- Home page with hero section, statistics, services, software, pricing, testimonials, and blog
- Services listing with category filtering
- Software products catalog
- Business Growth Plan pricing with monthly/yearly toggle
- Blog with categories and search
- Contact form with inquiry management
- SEO-optimized pages with meta tags
- WhatsApp integration

### User Panel
- User registration and login
- Dashboard with subscription overview
- My Subscriptions management
- Transaction history
- Support ticket system
- Profile management

### Admin Panel
- Secure admin authentication
- Dashboard with statistics
- User management
- Subscription management
- Services & Categories CRUD
- Software Products CRUD
- Blog Posts & Categories CRUD
- Pages CMS
- Testimonials management
- Contact Inquiries
- Support Tickets management
- Site Settings
- SEO Settings
- Payment Gateway Settings
- Email Settings

## Default Login Credentials

### Admin Login
- **URL**: `http://your-domain.com/admin/login.php`
- **Email**: admin@hostxolo.com
- **Password**: admin123

## Installation

### Requirements
- PHP 7.4 or higher
- MySQL 5.7 or higher
- Apache/Nginx web server
- mod_rewrite enabled (for Apache)

### Step 1: Download and Extract
1. Download the website files
2. Extract to your web server directory (e.g., `htdocs/hostxolo` for XAMPP)

### Step 2: Create Database
1. Open phpMyAdmin (http://localhost/phpmyadmin)
2. Click on "SQL" tab
3. Copy the contents of `database.sql` file
4. Paste into the SQL window and click "Go"

Or use MySQL command line:
```bash
mysql -u root -p < database.sql
```

### Step 3: Configure Database Connection
1. Open `config.php` file
2. Update database credentials:
```php
define('DB_HOST', 'localhost');
define('DB_USERNAME', 'root');
define('DB_PASSWORD', '');
define('DB_NAME', 'hostxolo');
```

### Step 4: Configure Site Settings
1. Open `config.php` file
2. Update base URL:
```php
define('BASE_URL', 'http://localhost/hostxolo/');
```

### Step 5: Set Folder Permissions
Ensure these directories have write permissions (755 or 777):
- `uploads/`
- `logs/`

### Step 6: Access the Website
- **Frontend**: http://localhost/hostxolo/
- **Admin Panel**: http://localhost/hostxolo/admin/login.php

## Folder Structure

```
hostxolo/
├── admin/                 # Admin Panel
│   ├── includes/         # Admin header/footer
│   ├── login.php         # Admin login
│   ├── dashboard.php     # Admin dashboard
│   ├── users.php         # User management
│   ├── services.php      # Service management
│   ├── software.php      # Software management
│   ├── plans.php         # Subscription plans
│   ├── blog-posts.php    # Blog management
│   ├── settings.php      # Site settings
│   └── logout.php        # Admin logout
├── assets/               # Frontend assets
│   ├── css/              # Stylesheets
│   └── js/               # JavaScript files
├── includes/             # Frontend includes
│   ├── header.php        # Header template
│   └── footer.php        # Footer template
├── uploads/              # File uploads directory
├── user/                 # User Panel
│   ├── includes/         # User header/footer
│   ├── dashboard.php     # User dashboard
│   ├── subscriptions.php
│   ├── tickets.php
│   └── profile.php
├── about.php             # About Us page
├── blog.php              # Blog listing
├── config.php            # Configuration file
├── contact.php           # Contact page
├── database.sql          # Database schema
├── index.php             # Homepage
├── login.php             # User login
├── logout.php            # User logout
├── plans.php             # Pricing page
├── register.php          # User registration
├── services.php          # Services page
├── software.php          # Software page
├── subscribe.php         # Subscription page
└── README.md             # This file
```

## Payment Gateway Integration

The website is structured to support multiple payment gateways:

### Razorpay (India)
1. Sign up at https://razorpay.com
2. Get your API keys from Dashboard
3. Update `config.php`:
```php
define('RAZORPAY_KEY_ID', 'your_key_id');
define('RAZORPAY_KEY_SECRET', 'your_key_secret');
```

### Stripe
1. Sign up at https://stripe.com
2. Get your API keys
3. Update `config.php`:
```php
define('STRIPE_PUBLISHABLE_KEY', 'your_publishable_key');
define('STRIPE_SECRET_KEY', 'your_secret_key');
```

### PayPal
1. Sign up at https://developer.paypal.com
2. Get your client credentials
3. Update `config.php`:
```php
define('PAYPAL_CLIENT_ID', 'your_client_id');
define('PAYPAL_CLIENT_SECRET', 'your_client_secret');
```

## Email Configuration

To send emails (notifications, password resets, etc.):

1. Update SMTP settings in `config.php`:
```php
define('SMTP_HOST', 'smtp.gmail.com');
define('SMTP_PORT', 587);
define('SMTP_USERNAME', 'your-email@gmail.com');
define('SMTP_PASSWORD', 'your-app-password');
define('SMTP_ENCRYPTION', 'tls');
```

2. For Gmail, enable "Less secure app access" or use App Passwords

## Security Features

- Password hashing with bcrypt
- CSRF protection on all forms
- SQL injection prevention with prepared statements
- XSS protection with output sanitization
- Session security with regeneration
- Login attempt limiting

## Customization

### Change Site Name/Logo
1. Login to Admin Panel
2. Go to Settings > General
3. Update site name, email, phone, address

### Modify Content
- **Homepage Sections**: Admin > Settings > Homepage Sections
- **Services**: Admin > Services
- **Software**: Admin > Software Products
- **Pricing**: Admin > Subscription Plans
- **Blog**: Admin > Blog Posts

### Change Colors/Theme
Edit `assets/css/style.css` and modify the CSS variables:
```css
:root {
    --primary-color: #2563eb;
    --secondary-color: #f59e0b;
    --dark-color: #1f2937;
    --light-color: #f3f4f6;
}
```

## Support

For support or customizations:
- Email: support@hostxolo.com
- WhatsApp: +91-6388758325

## License

This project is proprietary software. All rights reserved.

## Credits

- Bootstrap 5 - https://getbootstrap.com
- Bootstrap Icons - https://icons.getbootstrap.com
- Google Fonts - Inter

---

**Hostxolo - Your Business Growth Partner**
