<?php
/**
 * Hostxolo - Enhanced About Us Page
 */
require_once 'config.php';

// Get page content from database
$page_slug = 'about-us';
try {
    $stmt = db()->prepare("SELECT * FROM pages WHERE slug = ? AND status = 1");
    $stmt->execute([$page_slug]);
    $page = $stmt->fetch();
} catch (PDOException $e) {
    $page = null;
}

// Get team members
$team_members = [];
try {
    $stmt = db()->query("SELECT * FROM team_members WHERE status = 1 ORDER BY sort_order");
    $team_members = $stmt->fetchAll();
} catch (PDOException $e) {}

// Stats
$stats = [
    ['value' => '7+', 'label' => 'Years Experience', 'icon' => 'bi-calendar-check'],
    ['value' => '250+', 'label' => 'Happy Clients', 'icon' => 'bi-people'],
    ['value' => '10+', 'label' => 'Countries Served', 'icon' => 'bi-globe'],
    ['value' => '480+', 'label' => 'Projects Completed', 'icon' => 'bi-briefcase']
];

// Core values
$values = [
    [
        'title' => 'Customer First',
        'description' => 'We prioritize our customers needs and work tirelessly to exceed their expectations.',
        'icon' => 'bi-heart'
    ],
    [
        'title' => 'Innovation',
        'description' => 'We embrace cutting-edge technology to deliver modern solutions.',
        'icon' => 'bi-lightbulb'
    ],
    [
        'title' => 'Integrity',
        'description' => 'We believe in transparency and honest business practices.',
        'icon' => 'bi-shield-check'
    ],
    [
        'title' => 'Excellence',
        'description' => 'We strive for excellence in everything we do.',
        'icon' => 'bi-star'
    ]
];

include 'includes/header.php';
?>

<style>
.about-hero {
    background: linear-gradient(135deg, #f97316 0%, #ea580c 50%, #c2410c 100%);
    padding: 5rem 0;
    position: relative;
    overflow: hidden;
}
.about-hero::before {
    content: '';
    position: absolute;
    top: -30%;
    right: -10%;
    width: 500px;
    height: 500px;
    background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
    border-radius: 50%;
}
.about-hero::after {
    content: '';
    position: absolute;
    bottom: -40%;
    left: -10%;
    width: 400px;
    height: 400px;
    background: radial-gradient(circle, rgba(255,255,255,0.08) 0%, transparent 70%);
    border-radius: 50%;
}
.stat-card {
    background: white;
    border-radius: 20px;
    padding: 2rem;
    text-align: center;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
    transition: all 0.3s ease;
}
.stat-card:hover {
    transform: translateY(-8px);
    box-shadow: 0 20px 40px rgba(0,0,0,0.15);
}
.stat-icon {
    width: 70px;
    height: 70px;
    background: linear-gradient(135deg, #fff7ed 0%, #fed7aa 100%);
    border-radius: 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1rem;
    font-size: 2rem;
    color: #f97316;
}
.value-card {
    background: white;
    border-radius: 20px;
    padding: 2rem;
    text-align: center;
    box-shadow: 0 4px 15px rgba(0,0,0,0.05);
    transition: all 0.3s ease;
    border: 1px solid #f3f4f6;
}
.value-card:hover {
    transform: translateY(-8px);
    box-shadow: 0 15px 30px rgba(0,0,0,0.1);
    border-color: #f97316;
}
.value-icon {
    width: 80px;
    height: 80px;
    background: linear-gradient(135deg, #f97316 0%, #ea580c 100%);
    border-radius: 24px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1.5rem;
    font-size: 2.5rem;
    color: white;
}
.team-card {
    background: white;
    border-radius: 20px;
    overflow: hidden;
    box-shadow: 0 4px 15px rgba(0,0,0,0.05);
    transition: all 0.3s ease;
}
.team-card:hover {
    transform: translateY(-8px);
    box-shadow: 0 20px 40px rgba(0,0,0,0.1);
}
.team-avatar {
    width: 120px;
    height: 120px;
    border-radius: 50%;
    background: linear-gradient(135deg, #fff7ed 0%, #fed7aa 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    margin: -60px auto 1rem;
    border: 5px solid white;
    font-size: 3rem;
    color: #f97316;
}
.mission-section {
    background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
    border-radius: 30px;
    padding: 4rem;
}
.timeline-item {
    position: relative;
    padding-left: 3rem;
    padding-bottom: 2rem;
}
.timeline-item::before {
    content: '';
    position: absolute;
    left: 0;
    top: 0;
    width: 20px;
    height: 20px;
    background: #f97316;
    border-radius: 50%;
    border: 4px solid white;
    box-shadow: 0 0 0 4px #dbeafe;
}
.timeline-item::after {
    content: '';
    position: absolute;
    left: 9px;
    top: 20px;
    width: 2px;
    height: calc(100% - 20px);
    background: #dbeafe;
}
.timeline-item:last-child::after {
    display: none;
}
</style>

<!-- Hero Section -->
<section class="about-hero text-white">
    <div class="container position-relative" style="z-index: 1;">
        <div class="row justify-content-center text-center">
            <div class="col-lg-8">
                <span class="badge bg-white text-primary mb-3 px-3 py-2">
                    <i class="bi bi-info-circle me-2"></i>About Us
                </span>
                <h1 class="display-4 fw-bold mb-3">Building Digital Success Stories</h1>
                <p class="lead opacity-90">We are a team of passionate experts dedicated to helping businesses grow in the digital age.</p>
            </div>
        </div>
    </div>
</section>

<!-- Stats Section -->
<section class="py-5" style="margin-top: -3rem;">
    <div class="container">
        <div class="row g-4">
            <?php foreach ($stats as $stat): ?>
            <div class="col-6 col-md-3">
                <div class="stat-card">
                    <div class="stat-icon">
                        <i class="bi <?php echo $stat['icon']; ?>"></i>
                    </div>
                    <h3 class="display-5 fw-bold text-primary mb-1"><?php echo $stat['value']; ?></h3>
                    <p class="text-muted mb-0"><?php echo $stat['label']; ?></p>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<!-- Mission & Vision -->
<section class="py-5">
    <div class="container">
        <div class="mission-section">
            <div class="row g-5 align-items-center">
                <div class="col-lg-6">
                    <span class="badge bg-primary bg-opacity-10 text-primary mb-3 px-3 py-2">Our Mission</span>
                    <h2 class="fw-bold mb-4">Empowering Businesses Through Digital Innovation</h2>
                    <p class="text-muted mb-4">At Hostxolo, we believe every business deserves access to powerful digital tools and expert guidance. Our mission is to democratize business technology and help small to medium enterprises compete in the modern marketplace.</p>
                    
                    <div class="d-flex gap-4 mb-4">
                        <div class="d-flex align-items-center">
                            <i class="bi bi-check-circle-fill text-success fs-4 me-2"></i>
                            <span>Innovation First</span>
                        </div>
                        <div class="d-flex align-items-center">
                            <i class="bi bi-check-circle-fill text-success fs-4 me-2"></i>
                            <span>Customer Focus</span>
                        </div>
                    </div>
                    
                    <a href="<?php echo BASE_URL; ?>services.php" class="btn btn-primary btn-lg">
                        <i class="bi bi-arrow-right me-2"></i>Explore Our Services
                    </a>
                </div>
                <div class="col-lg-6">
                    <div class="row g-3">
                        <div class="col-6">
                            <div class="card border-0 shadow-sm h-100">
                                <div class="card-body text-center p-4">
                                    <i class="bi bi-rocket text-primary fs-1 mb-3"></i>
                                    <h5 class="fw-bold">Launch</h5>
                                    <small class="text-muted">Start your journey</small>
                                </div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="card border-0 shadow-sm h-100">
                                <div class="card-body text-center p-4">
                                    <i class="bi bi-graph-up-arrow text-success fs-1 mb-3"></i>
                                    <h5 class="fw-bold">Grow</h5>
                                    <small class="text-muted">Scale rapidly</small>
                                </div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="card border-0 shadow-sm h-100">
                                <div class="card-body text-center p-4">
                                    <i class="bi bi-trophy text-warning fs-1 mb-3"></i>
                                    <h5 class="fw-bold">Succeed</h5>
                                    <small class="text-muted">Achieve goals</small>
                                </div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="card border-0 shadow-sm h-100">
                                <div class="card-body text-center p-4">
                                    <i class="bi bi-stars text-info fs-1 mb-3"></i>
                                    <h5 class="fw-bold">Lead</h5>
                                    <small class="text-muted">Dominate market</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Core Values -->
<section class="py-5 bg-light">
    <div class="container">
        <div class="text-center mb-5">
            <span class="badge bg-primary bg-opacity-10 text-primary mb-3 px-3 py-2">Our Values</span>
            <h2 class="fw-bold">What We Stand For</h2>
            <p class="text-muted">The principles that guide everything we do</p>
        </div>
        
        <div class="row g-4">
            <?php foreach ($values as $value): ?>
            <div class="col-md-6 col-lg-3">
                <div class="value-card h-100">
                    <div class="value-icon">
                        <i class="bi <?php echo $value['icon']; ?>"></i>
                    </div>
                    <h5 class="fw-bold mb-3"><?php echo $value['title']; ?></h5>
                    <p class="text-muted mb-0"><?php echo $value['description']; ?></p>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<!-- Why Choose Us -->
<section class="py-5">
    <div class="container">
        <div class="row g-5 align-items-center">
            <div class="col-lg-6">
                <span class="badge bg-primary bg-opacity-10 text-primary mb-3 px-3 py-2">Why Choose Us</span>
                <h2 class="fw-bold mb-4">Your Success is Our Priority</h2>
                <p class="text-muted mb-4">With over 7 years of experience, we have helped hundreds of businesses transform their digital presence and achieve remarkable growth.</p>
                
                <div class="timeline-item">
                    <h5 class="fw-bold mb-2">Expert Team</h5>
                    <p class="text-muted mb-0">Our team consists of industry experts with deep knowledge in digital marketing, development, and business strategy.</p>
                </div>
                
                <div class="timeline-item">
                    <h5 class="fw-bold mb-2">Proven Results</h5>
                    <p class="text-muted mb-0">We have a track record of delivering measurable results for our clients across various industries.</p>
                </div>
                
                <div class="timeline-item">
                    <h5 class="fw-bold mb-2">24/7 Support</h5>
                    <p class="text-muted mb-0">Our dedicated support team is always available to help you with any questions or issues.</p>
                </div>
                
                <div class="timeline-item" style="padding-bottom: 0;">
                    <h5 class="fw-bold mb-2">Affordable Pricing</h5>
                    <p class="text-muted mb-0">We offer competitive pricing without compromising on quality or service.</p>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="card border-0 shadow-lg">
                    <div class="card-body p-5">
                        <h4 class="fw-bold mb-4">Ready to Grow Your Business?</h4>
                        <p class="text-muted mb-4">Join 250+ satisfied customers who trust Hostxolo for their business growth needs.</p>
                        
                        <div class="d-grid gap-3">
                            <a href="<?php echo BASE_URL; ?>plans.php" class="btn btn-primary btn-lg">
                                <i class="bi bi-rocket me-2"></i>Get Started Today
                            </a>
                            <a href="<?php echo BASE_URL; ?>contact.php" class="btn btn-outline-primary btn-lg">
                                <i class="bi bi-chat-dots me-2"></i>Talk to an Expert
                            </a>
                        </div>
                        
                        <hr class="my-4">
                        
                        <div class="d-flex align-items-center justify-content-center gap-2">
                            <i class="bi bi-shield-check text-success fs-4"></i>
                            <span class="text-muted">7-day money-back guarantee</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Team Section -->
<?php if (!empty($team_members)): ?>
<section class="py-5 bg-light">
    <div class="container">
        <div class="text-center mb-5">
            <span class="badge bg-primary bg-opacity-10 text-primary mb-3 px-3 py-2">Our Team</span>
            <h2 class="fw-bold">Meet the Experts</h2>
            <p class="text-muted">The talented people behind Hostxolo</p>
        </div>
        
        <div class="row g-4">
            <?php foreach ($team_members as $member): ?>
            <div class="col-md-6 col-lg-3">
                <div class="team-card text-center">
                    <div class="bg-primary" style="height: 100px;"></div>
                    <div class="card-body p-4 pt-0">
                        <div class="team-avatar">
                            <?php if ($member['image']): ?>
                                <img src="<?php echo UPLOADS_URL . $member['image']; ?>" alt="<?php echo $member['name']; ?>" class="rounded-circle" style="width: 110px; height: 110px; object-fit: cover;">
                            <?php else: ?>
                                <i class="bi bi-person"></i>
                            <?php endif; ?>
                        </div>
                        <h5 class="fw-bold mb-1"><?php echo $member['name']; ?></h5>
                        <p class="text-primary mb-2"><?php echo $member['designation']; ?></p>
                        <?php if ($member['bio']): ?>
                            <p class="text-muted small mb-3"><?php echo substr($member['bio'], 0, 80); ?>...</p>
                        <?php endif; ?>
                        <div class="d-flex justify-content-center gap-2">
                            <?php if ($member['linkedin']): ?>
                                <a href="<?php echo $member['linkedin']; ?>" class="btn btn-outline-primary btn-sm rounded-circle" target="_blank"><i class="bi bi-linkedin"></i></a>
                            <?php endif; ?>
                            <?php if ($member['twitter']): ?>
                                <a href="<?php echo $member['twitter']; ?>" class="btn btn-outline-primary btn-sm rounded-circle" target="_blank"><i class="bi bi-twitter"></i></a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- CTA Section -->
<section class="py-5">
    <div class="container">
        <div class="card border-0 shadow-lg bg-primary text-white overflow-hidden">
            <div class="card-body p-5 position-relative">
                <!-- Decorative circles -->
                <div class="position-absolute" style="top: -50px; right: -50px; width: 200px; height: 200px; background: rgba(255,255,255,0.1); border-radius: 50%;"></div>
                <div class="position-absolute" style="bottom: -30px; left: -30px; width: 150px; height: 150px; background: rgba(255,255,255,0.08); border-radius: 50%;"></div>
                
                <div class="row align-items-center position-relative" style="z-index: 1;">
                    <div class="col-lg-8">
                        <h2 class="fw-bold mb-3">Ready to Transform Your Business?</h2>
                        <p class="lead opacity-90 mb-0">Join thousands of successful businesses that trust Hostxolo for their growth journey.</p>
                    </div>
                    <div class="col-lg-4 text-lg-end mt-4 mt-lg-0">
                        <a href="<?php echo BASE_URL; ?>plans.php" class="btn btn-light btn-lg">
                            <i class="bi bi-rocket me-2"></i>Start Now
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>

