<?php
/**
 * Admin - Blog Categories
 */
require_once __DIR__ . '/../config.php';
require_admin_login();

$page_title = 'Blog Categories';

$categories = [];
try {
    $stmt = db()->query("SELECT * FROM blog_categories ORDER BY name ASC");
    $categories = $stmt->fetchAll();
} catch (PDOException $e) {}

include __DIR__ . '/includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="fw-bold mb-0">Blog Categories</h2>
    <a href="blog-category-add.php" class="btn btn-primary"><i class="bi bi-plus-lg me-2"></i>Add Category</a>
</div>

<div class="card border-0 shadow-sm">
    <div class="table-responsive">
        <table class="table table-hover mb-0">
            <thead class="table-light">
                <tr>
                    <th>Name</th>
                    <th>Slug</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($categories as $cat): ?>
                <tr>
                    <td><?php echo $cat['name']; ?></td>
                    <td><code><?php echo $cat['slug']; ?></code></td>
                    <td>
                        <span class="badge bg-<?php echo $cat['status'] ? 'success' : 'secondary'; ?>">
                            <?php echo $cat['status'] ? 'Active' : 'Inactive'; ?>
                        </span>
                    </td>
                    <td>
                        <a href="blog-category-edit.php?id=<?php echo $cat['id']; ?>" class="btn btn-sm btn-outline-primary">
                            <i class="bi bi-pencil"></i>
                        </a>
                        <button class="btn btn-sm btn-outline-danger" onclick="deleteCategory(<?php echo $cat['id']; ?>)">
                            <i class="bi bi-trash"></i>
                        </button>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php if (empty($categories)): ?>
                <tr><td colspan="4" class="text-center py-4 text-muted">No categories found</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<script>
function deleteCategory(categoryId) {
    if (confirm('Are you sure you want to delete this category? This action cannot be undone.')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = 'blog-category-delete.php';
        
        const csrfToken = document.createElement('input');
        csrfToken.type = 'hidden';
        csrfToken.name = 'csrf_token';
        csrfToken.value = '<?php echo generate_csrf_token(); ?>';
        
        const categoryIdField = document.createElement('input');
        categoryIdField.type = 'hidden';
        categoryIdField.name = 'category_id';
        categoryIdField.value = categoryId;
        
        form.appendChild(csrfToken);
        form.appendChild(categoryIdField);
        document.body.appendChild(form);
        form.submit();
    }
}
</script>

<?php include __DIR__ . '/includes/footer.php'; ?>
