<?php
/**
 * Admin - Blog Posts
 */
require_once __DIR__ . '/../config.php';
require_admin_login();

$page_title = 'Blog Posts';

$posts = [];
try {
    $stmt = db()->query("SELECT bp.*, bc.name as category_name 
                        FROM blog_posts bp
                        LEFT JOIN blog_categories bc ON bp.category_id = bc.id
                        ORDER BY bp.created_at DESC");
    $posts = $stmt->fetchAll();
} catch (PDOException $e) {}

include __DIR__ . '/includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="fw-bold mb-0">Blog Posts</h2>
    <a href="blog-post-add.php" class="btn btn-primary"><i class="bi bi-plus-lg me-2"></i>Add Post</a>
</div>

<div class="card border-0 shadow-sm">
    <div class="table-responsive">
        <table class="table table-hover mb-0">
            <thead class="table-light">
                <tr>
                    <th>Title</th>
                    <th>Category</th>
                    <th>Status</th>
                    <th>Published</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($posts as $post): ?>
                <tr>
                    <td><?php echo substr($post['title'], 0, 50); ?>...</td>
                    <td><?php echo $post['category_name'] ?? 'Uncategorized'; ?></td>
                    <td>
                        <span class="badge bg-<?php echo $post['status'] === 'published' ? 'success' : 'warning'; ?>">
                            <?php echo ucfirst($post['status']); ?>
                        </span>
                    </td>
                    <td><?php echo $post['published_at'] ? format_date($post['published_at']) : '-'; ?></td>
                    <td>
                        <a href="blog-post-edit.php?id=<?php echo $post['id']; ?>" class="btn btn-sm btn-outline-primary">
                            <i class="bi bi-pencil"></i>
                        </a>
                        <button class="btn btn-sm btn-outline-danger" onclick="deletePost(<?php echo $post['id']; ?>)">
                            <i class="bi bi-trash"></i>
                        </button>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php if (empty($posts)): ?>
                <tr><td colspan="5" class="text-center py-4 text-muted">No posts found</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<script>
function deletePost(postId) {
    if (confirm('Are you sure you want to delete this blog post? This action cannot be undone.')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = 'blog-post-delete.php';
        
        const csrfToken = document.createElement('input');
        csrfToken.type = 'hidden';
        csrfToken.name = 'csrf_token';
        csrfToken.value = '<?php echo generate_csrf_token(); ?>';
        
        const postIdField = document.createElement('input');
        postIdField.type = 'hidden';
        postIdField.name = 'post_id';
        postIdField.value = postId;
        
        form.appendChild(csrfToken);
        form.appendChild(postIdField);
        document.body.appendChild(form);
        form.submit();
    }
}
</script>

<?php include __DIR__ . '/includes/footer.php'; ?>
