<?php
/**
 * Hostxolo - Admin Dashboard
 */
require_once __DIR__ . '/../config.php';
require_admin_login();

// Get dashboard statistics
$stats = [];

try {
    // Total Users
    $stmt = db()->query("SELECT COUNT(*) as total FROM users");
    $stats['total_users'] = $stmt->fetch()['total'];
    
    // Active Subscriptions
    $stmt = db()->query("SELECT COUNT(*) as total FROM user_subscriptions WHERE status = 'active'");
    $stats['active_subscriptions'] = $stmt->fetch()['total'];
    
    // Total Revenue
    $stmt = db()->query("SELECT COALESCE(SUM(total_amount), 0) as total FROM transactions WHERE status = 'success'");
    $stats['total_revenue'] = $stmt->fetch()['total'];
    
    // Pending Tickets
    $stmt = db()->query("SELECT COUNT(*) as total FROM support_tickets WHERE status IN ('open', 'in_progress')");
    $stats['pending_tickets'] = $stmt->fetch()['total'];
    
    // Recent Users
    $stmt = db()->query("SELECT * FROM users ORDER BY created_at DESC LIMIT 5");
    $recent_users = $stmt->fetchAll();
    
    // Recent Transactions
    $stmt = db()->query("SELECT t.*, u.full_name, u.email 
                        FROM transactions t 
                        JOIN users u ON t.user_id = u.id 
                        ORDER BY t.created_at DESC LIMIT 5");
    $recent_transactions = $stmt->fetchAll();
    
    // Recent Tickets
    $stmt = db()->query("SELECT t.*, u.full_name, u.email 
                        FROM support_tickets t 
                        JOIN users u ON t.user_id = u.id 
                        ORDER BY t.created_at DESC LIMIT 5");
    $recent_tickets = $stmt->fetchAll();
    
} catch (PDOException $e) {
    $recent_users = [];
    $recent_transactions = [];
    $recent_tickets = [];
}

include __DIR__ . '/includes/header.php';
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Dashboard</h1>
    <div class="btn-toolbar mb-2 mb-md-0">
        <div class="btn-group me-2">
            <a href="<?php echo BASE_URL; ?>" target="_blank" class="btn btn-sm btn-outline-primary">
                <i class="bi bi-globe me-1"></i>View Website
            </a>
        </div>
    </div>
</div>

<!-- Stats Cards -->
<div class="row g-4 mb-4">
    <div class="col-md-6 col-xl-3">
        <div class="card stat-card border-0 shadow-sm h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-muted text-uppercase mb-1" style="font-size: 0.75rem;">Total Users</h6>
                        <h3 class="fw-bold mb-0"><?php echo number_format($stats['total_users'] ?? 0); ?></h3>
                    </div>
                    <div class="icon bg-primary bg-opacity-10 text-primary rounded">
                        <i class="bi bi-people fs-4"></i>
                    </div>
                </div>
                <a href="users.php" class="small text-decoration-none">View all <i class="bi bi-arrow-right"></i></a>
            </div>
        </div>
    </div>
    
    <div class="col-md-6 col-xl-3">
        <div class="card stat-card border-0 shadow-sm h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-muted text-uppercase mb-1" style="font-size: 0.75rem;">Active Subscriptions</h6>
                        <h3 class="fw-bold mb-0"><?php echo number_format($stats['active_subscriptions'] ?? 0); ?></h3>
                    </div>
                    <div class="icon bg-success bg-opacity-10 text-success rounded">
                        <i class="bi bi-credit-card fs-4"></i>
                    </div>
                </div>
                <a href="subscriptions.php" class="small text-decoration-none">View all <i class="bi bi-arrow-right"></i></a>
            </div>
        </div>
    </div>
    
    <div class="col-md-6 col-xl-3">
        <div class="card stat-card border-0 shadow-sm h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-muted text-uppercase mb-1" style="font-size: 0.75rem;">Total Revenue</h6>
                        <h3 class="fw-bold mb-0"><?php echo format_currency($stats['total_revenue'] ?? 0); ?></h3>
                    </div>
                    <div class="icon bg-warning bg-opacity-10 text-warning rounded">
                        <i class="bi bi-currency-rupee fs-4"></i>
                    </div>
                </div>
                <a href="transactions.php" class="small text-decoration-none">View all <i class="bi bi-arrow-right"></i></a>
            </div>
        </div>
    </div>
    
    <div class="col-md-6 col-xl-3">
        <div class="card stat-card border-0 shadow-sm h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-muted text-uppercase mb-1" style="font-size: 0.75rem;">Pending Tickets</h6>
                        <h3 class="fw-bold mb-0"><?php echo number_format($stats['pending_tickets'] ?? 0); ?></h3>
                    </div>
                    <div class="icon bg-danger bg-opacity-10 text-danger rounded">
                        <i class="bi bi-headset fs-4"></i>
                    </div>
                </div>
                <a href="tickets.php" class="small text-decoration-none">View all <i class="bi bi-arrow-right"></i></a>
            </div>
        </div>
    </div>
</div>

<div class="row g-4">
    <!-- Recent Users -->
    <div class="col-lg-6">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                <h5 class="mb-0 fw-bold">Recent Users</h5>
                <a href="users.php" class="btn btn-sm btn-outline-primary">View All</a>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>User</th>
                                <th>Email</th>
                                <th>Joined</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($recent_users as $user): ?>
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="bg-primary bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center me-2" style="width: 35px; height: 35px;">
                                            <i class="bi bi-person text-primary"></i>
                                        </div>
                                        <?php echo $user['full_name']; ?>
                                    </div>
                                </td>
                                <td><?php echo $user['email']; ?></td>
                                <td><?php echo format_date($user['created_at']); ?></td>
                                <td>
                                    <span class="badge bg-<?php echo $user['status'] === 'active' ? 'success' : 'secondary'; ?>">
                                        <?php echo ucfirst($user['status']); ?>
                                    </span>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                            <?php if (empty($recent_users)): ?>
                            <tr>
                                <td colspan="4" class="text-center py-3 text-muted">No users yet</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Recent Transactions -->
    <div class="col-lg-6">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                <h5 class="mb-0 fw-bold">Recent Transactions</h5>
                <a href="transactions.php" class="btn btn-sm btn-outline-primary">View All</a>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>User</th>
                                <th>Amount</th>
                                <th>Status</th>
                                <th>Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($recent_transactions as $tx): ?>
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="bg-success bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center me-2" style="width: 35px; height: 35px;">
                                            <i class="bi bi-currency-rupee text-success"></i>
                                        </div>
                                        <?php echo $tx['full_name']; ?>
                                    </div>
                                </td>
                                <td><?php echo format_currency($tx['total_amount']); ?></td>
                                <td>
                                    <span class="badge bg-<?php 
                                        echo $tx['status'] === 'success' ? 'success' : 
                                            ($tx['status'] === 'pending' ? 'warning' : 'danger'); 
                                    ?>">
                                        <?php echo ucfirst($tx['status']); ?>
                                    </span>
                                </td>
                                <td><?php echo format_date($tx['created_at']); ?></td>
                            </tr>
                            <?php endforeach; ?>
                            <?php if (empty($recent_transactions)): ?>
                            <tr>
                                <td colspan="4" class="text-center py-3 text-muted">No transactions yet</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Support Tickets -->
<div class="row mt-4">
    <div class="col-12">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                <h5 class="mb-0 fw-bold">Recent Support Tickets</h5>
                <a href="tickets.php" class="btn btn-sm btn-outline-primary">View All</a>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Ticket #</th>
                                <th>User</th>
                                <th>Subject</th>
                                <th>Priority</th>
                                <th>Status</th>
                                <th>Created</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($recent_tickets as $ticket): ?>
                            <tr>
                                <td><a href="ticket-view.php?id=<?php echo $ticket['id']; ?>">#<?php echo $ticket['ticket_number']; ?></a></td>
                                <td><?php echo $ticket['full_name']; ?></td>
                                <td><?php echo substr($ticket['subject'], 0, 50); ?>...</td>
                                <td>
                                    <span class="badge bg-<?php 
                                        echo $ticket['priority'] === 'urgent' ? 'danger' : 
                                            ($ticket['priority'] === 'high' ? 'warning' : 
                                            ($ticket['priority'] === 'medium' ? 'info' : 'secondary')); 
                                    ?>">
                                        <?php echo ucfirst($ticket['priority']); ?>
                                    </span>
                                </td>
                                <td>
                                    <span class="badge bg-<?php 
                                        echo $ticket['status'] === 'open' ? 'danger' : 
                                            ($ticket['status'] === 'in_progress' ? 'warning' : 'success'); 
                                    ?>">
                                        <?php echo ucfirst(str_replace('_', ' ', $ticket['status'])); ?>
                                    </span>
                                </td>
                                <td><?php echo format_date($ticket['created_at']); ?></td>
                            </tr>
                            <?php endforeach; ?>
                            <?php if (empty($recent_tickets)): ?>
                            <tr>
                                <td colspan="6" class="text-center py-3 text-muted">No tickets yet</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>
