<?php
/**
 * Admin - Email Settings
 */
require_once __DIR__ . '/../config.php';
require_admin_login();

$page_title = 'Email Settings';

include __DIR__ . '/includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="fw-bold mb-0">Email Settings</h2>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-body">
        <form method="POST">
            <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">
            
            <h5 class="mb-3">SMTP Configuration</h5>
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">SMTP Host</label>
                    <input type="text" name="smtp_host" class="form-control" placeholder="smtp.gmail.com">
                </div>
                <div class="col-md-6">
                    <label class="form-label">SMTP Port</label>
                    <input type="number" name="smtp_port" class="form-control" placeholder="587">
                </div>
                <div class="col-md-6">
                    <label class="form-label">SMTP Username</label>
                    <input type="text" name="smtp_username" class="form-control" placeholder="your-email@gmail.com">
                </div>
                <div class="col-md-6">
                    <label class="form-label">SMTP Password</label>
                    <input type="password" name="smtp_password" class="form-control" placeholder="App Password">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Encryption</label>
                    <select name="smtp_encryption" class="form-select">
                        <option value="tls">TLS</option>
                        <option value="ssl">SSL</option>
                        <option value="none">None</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label class="form-label">From Email</label>
                    <input type="email" name="email_from" class="form-control" placeholder="noreply@hostxolo.com">
                </div>
            </div>
            
            <div class="alert alert-info mt-4">
                <i class="bi bi-info-circle me-2"></i>
                Note: Update these settings in the config.php file directly.
            </div>
            
            <div class="mt-4">
                <button type="submit" class="btn btn-primary" disabled>
                    <i class="bi bi-save me-2"></i>Save Settings (Edit config.php)
                </button>
            </div>
        </form>
    </div>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>
