<?php
/**
 * Admin - Add FAQ
 */
require_once __DIR__ . '/../config.php';
require_admin_login();

$page_title = 'Add FAQ';
$errors = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verify_csrf_token($_POST['csrf_token'] ?? '')) {
        $errors[] = 'Invalid security token';
    } else {
        $question = sanitize($_POST['question'] ?? '');
        $answer = sanitize($_POST['answer'] ?? '');
        $category = sanitize($_POST['category'] ?? 'general');
        $sort_order = intval($_POST['sort_order'] ?? 0);
        $is_active = isset($_POST['is_active']) ? 1 : 0;
        
        if (empty($question)) $errors[] = 'Question is required';
        if (empty($answer)) $errors[] = 'Answer is required';
        
        if (empty($errors)) {
            try {
                $stmt = db()->prepare("INSERT INTO faqs 
                    (question, answer, category, sort_order, is_active) 
                    VALUES (?, ?, ?, ?, ?)");
                $stmt->execute([$question, $answer, $category, $sort_order, $is_active]);
                redirect(BASE_URL . 'admin/faqs.php', 'success', 'FAQ added successfully');
            } catch (PDOException $e) {
                $errors[] = 'Failed to add FAQ: ' . $e->getMessage();
            }
        }
    }
}

$csrf_token = generate_csrf_token();
include __DIR__ . '/includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="fw-bold mb-0">Add FAQ</h2>
    <a href="faqs.php" class="btn btn-outline-secondary"><i class="bi bi-arrow-left me-2"></i>Back</a>
</div>

<?php if (!empty($errors)): ?>
    <div class="alert alert-danger"><?php foreach ($errors as $error): ?><p class="mb-0"><?php echo $error; ?></p><?php endforeach; ?></div>
<?php endif; ?>

<div class="card border-0 shadow-sm">
    <div class="card-body p-4">
        <form method="POST">
            <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">Question <span class="text-danger">*</span></label>
                    <textarea name="question" class="form-control" rows="3" required></textarea>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Category</label>
                    <input type="text" name="category" class="form-control" value="general" list="categories">
                    <datalist id="categories">
                        <option value="general">
                        <option value="payment">
                        <option value="subscription">
                        <option value="services">
                        <option value="software">
                        <option value="support">
                        <option value="billing">
                    </datalist>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Sort Order</label>
                    <input type="number" name="sort_order" class="form-control" value="0">
                </div>
                <div class="col-12">
                    <label class="form-label">Answer <span class="text-danger">*</span></label>
                    <textarea name="answer" class="form-control" rows="6" required></textarea>
                </div>
                <div class="col-12">
                    <div class="form-check">
                        <input type="checkbox" name="is_active" class="form-check-input" id="statusCheck" checked>
                        <label class="form-check-label" for="statusCheck">Active</label>
                    </div>
                </div>
            </div>
            <div class="mt-4">
                <button type="submit" class="btn btn-primary"><i class="bi bi-save me-2"></i>Save FAQ</button>
                <a href="faqs.php" class="btn btn-outline-secondary ms-2">Cancel</a>
            </div>
        </form>
    </div>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>
