<?php
/**
 * Admin Panel - Header Template
 */
require_once __DIR__ . '/../../config.php';
require_admin_login();

$admin = [
    'name' => $_SESSION['admin_name'] ?? 'Admin',
    'email' => $_SESSION['admin_email'] ?? '',
    'role' => $_SESSION['admin_role'] ?? 'admin'
];

$current_page = basename($_SERVER['PHP_SELF'], '.php');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title ?? 'Admin Panel'; ?> - Hostxolo</title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="<?php echo ASSETS_URL; ?>css/style.css">
    
    <style>
        .admin-sidebar {
            min-height: calc(100vh - 56px);
            background: #1f2937;
        }
        .admin-sidebar .nav-link {
            color: #9ca3af;
            padding: 0.75rem 1rem;
            border-radius: 0.375rem;
            margin-bottom: 0.25rem;
        }
        .admin-sidebar .nav-link:hover,
        .admin-sidebar .nav-link.active {
            color: white;
            background: rgba(255,255,255,0.1);
        }
        .admin-sidebar .nav-link i {
            width: 1.5rem;
        }
        .navbar-brand {
            font-weight: 800;
        }
    </style>
</head>
<body>
    <!-- Top Navbar -->
    <nav class="navbar navbar-dark bg-dark sticky-top flex-md-nowrap p-2 shadow">
        <a class="navbar-brand col-md-3 col-lg-2 me-0 px-3" href="<?php echo BASE_URL; ?>admin/dashboard.php">
            <span class="text-primary">HOST</span>XOLO
        </a>
        
        <button class="navbar-toggler d-md-none collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#sidebarMenu">
            <span class="navbar-toggler-icon"></span>
        </button>
        
        <div class="dropdown ms-auto me-3">
            <a href="#" class="d-flex align-items-center text-white text-decoration-none dropdown-toggle" data-bs-toggle="dropdown">
                <div class="bg-primary rounded-circle d-flex align-items-center justify-content-center me-2" style="width: 32px; height: 32px;">
                    <i class="bi bi-person"></i>
                </div>
                <span class="d-none d-sm-inline"><?php echo $admin['name']; ?></span>
            </a>
            <ul class="dropdown-menu dropdown-menu-end">
                <li><a class="dropdown-item" href="profile.php"><i class="bi bi-person me-2"></i>Profile</a></li>
                <li><hr class="dropdown-divider"></li>
                <li><a class="dropdown-item" href="<?php echo BASE_URL; ?>" target="_blank"><i class="bi bi-globe me-2"></i>View Website</a></li>
                <li><hr class="dropdown-divider"></li>
                <li><a class="dropdown-item text-danger" href="logout.php"><i class="bi bi-box-arrow-right me-2"></i>Logout</a></li>
            </ul>
        </div>
    </nav>

    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <nav id="sidebarMenu" class="col-md-3 col-lg-2 d-md-block admin-sidebar collapse">
                <div class="position-sticky pt-3">
                    <ul class="nav flex-column">
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'dashboard' ? 'active' : ''; ?>" href="dashboard.php">
                                <i class="bi bi-speedometer2"></i> Dashboard
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'users' ? 'active' : ''; ?>" href="users.php">
                                <i class="bi bi-people"></i> Users
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'subscriptions' ? 'active' : ''; ?>" href="subscriptions.php">
                                <i class="bi bi-credit-card"></i> Subscriptions
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'transactions' ? 'active' : ''; ?>" href="transactions.php">
                                <i class="bi bi-currency-rupee"></i> Transactions
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'tickets' ? 'active' : ''; ?>" href="tickets.php">
                                <i class="bi bi-headset"></i> Support Tickets
                                <?php
                                // Get pending tickets count
                                try {
                                    $stmt = db()->query("SELECT COUNT(*) as count FROM support_tickets WHERE status IN ('open', 'in_progress')");
                                    $pending = $stmt->fetch()['count'];
                                    if ($pending > 0):
                                ?>
                                <span class="badge bg-danger ms-auto"><?php echo $pending; ?></span>
                                <?php endif; } catch (PDOException $e) {} ?>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo in_array($current_page, ['services', 'service-categories']) ? 'active' : ''; ?>" 
                               data-bs-toggle="collapse" href="#servicesMenu" role="button">
                                <i class="bi bi-briefcase"></i> Services
                                <i class="bi bi-chevron-down ms-auto small"></i>
                            </a>
                            <div class="collapse <?php echo in_array($current_page, ['services', 'service-categories']) ? 'show' : ''; ?>" id="servicesMenu">
                                <ul class="nav flex-column ms-3">
                                    <li class="nav-item">
                                        <a class="nav-link" href="services.php">All Services</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" href="service-categories.php">Categories</a>
                                    </li>
                                </ul>
                            </div>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'software' ? 'active' : ''; ?>" href="software.php" data-bs-toggle="collapse" data-bs-target="#softwareMenu" role="button">
                                <i class="bi bi-box-seam"></i> Software Products
                                <i class="bi bi-chevron-down ms-auto small"></i>
                            </a>
                            <div class="collapse <?php echo in_array($current_page, ['software', 'software-categories']) ? 'show' : ''; ?>" id="softwareMenu">
                                <ul class="nav flex-column ms-3">
                                    <li class="nav-item">
                                        <a class="nav-link" href="software.php">All Products</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" href="software-categories.php">Categories</a>
                                    </li>
                                </ul>
                            </div>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'plans' ? 'active' : ''; ?>" href="plans.php">
                                <i class="bi bi-tags"></i> Subscription Plans
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo in_array($current_page, ['blog-posts', 'blog-categories']) ? 'active' : ''; ?>" 
                               data-bs-toggle="collapse" href="#blogMenu" role="button">
                                <i class="bi bi-journal-text"></i> Blog
                                <i class="bi bi-chevron-down ms-auto small"></i>
                            </a>
                            <div class="collapse <?php echo in_array($current_page, ['blog-posts', 'blog-categories']) ? 'show' : ''; ?>" id="blogMenu">
                                <ul class="nav flex-column ms-3">
                                    <li class="nav-item">
                                        <a class="nav-link" href="blog-posts.php">All Posts</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" href="blog-categories.php">Categories</a>
                                    </li>
                                </ul>
                            </div>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'site-management' ? 'active' : ''; ?>" href="site-management.php">
                                <i class="bi bi-globe"></i> Site Management
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'pages' ? 'active' : ''; ?>" href="pages.php">
                                <i class="bi bi-file-earmark-text"></i> CMS Pages
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'testimonials' ? 'active' : ''; ?>" href="testimonials.php">
                                <i class="bi bi-chat-quote"></i> Testimonials
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'faqs' ? 'active' : ''; ?>" href="faqs.php">
                                <i class="bi bi-question-circle"></i> FAQs
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'coupons' ? 'active' : ''; ?>" href="coupons.php">
                                <i class="bi bi-ticket-perforated"></i> Coupons
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'newsletter-subscribers' ? 'active' : ''; ?>" href="newsletter-subscribers.php">
                                <i class="bi bi-envelope-paper"></i> Newsletter
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'inquiries' ? 'active' : ''; ?>" href="inquiries.php">
                                <i class="bi bi-envelope"></i> Contact Inquiries
                            </a>
                        </li>
                        <li class="nav-item mt-3">
                            <span class="nav-link text-white-50 text-uppercase small fw-bold" style="font-size: 0.75rem; letter-spacing: 1px;">
                                <i class="bi bi-gear-fill me-2"></i>Settings
                            </span>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $current_page === 'system-settings' ? 'active' : ''; ?>" href="system-settings.php">
                                <i class="bi bi-cpu"></i> System Settings
                            </a>
                        </li>
                    </ul>
                </div>
            </nav>

            <!-- Main Content -->
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="py-4">
                    <?php echo flash_message(); ?>
