<?php
/**
 * Admin - Contact Inquiries
 */
require_once __DIR__ . '/../config.php';
require_admin_login();

$page_title = 'Contact Inquiries';

$inquiries = [];
try {
    $stmt = db()->query("SELECT * FROM contact_inquiries ORDER BY created_at DESC");
    $inquiries = $stmt->fetchAll();
} catch (PDOException $e) {}

include __DIR__ . '/includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="fw-bold mb-0">Contact Inquiries</h2>
</div>

<div class="card border-0 shadow-sm">
    <div class="table-responsive">
        <table class="table table-hover mb-0">
            <thead class="table-light">
                <tr>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Phone</th>
                    <th>Subject</th>
                    <th>Status</th>
                    <th>Date</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($inquiries as $inquiry): ?>
                <tr>
                    <td><?php echo $inquiry['name']; ?></td>
                    <td><?php echo $inquiry['email']; ?></td>
                    <td><?php echo $inquiry['phone'] ?? '-'; ?></td>
                    <td><?php echo substr($inquiry['subject'], 0, 30); ?>...</td>
                    <td>
                        <span class="badge bg-<?php echo $inquiry['status'] === 'unread' ? 'danger' : 'success'; ?>">
                            <?php echo ucfirst($inquiry['status']); ?>
                        </span>
                    </td>
                    <td><?php echo format_date($inquiry['created_at']); ?></td>
                    <td>
                        <a href="inquiry-view.php?id=<?php echo $inquiry['id']; ?>" class="btn btn-sm btn-outline-primary">
                            <i class="bi bi-eye"></i>
                        </a>
                        <button class="btn btn-sm btn-outline-danger" onclick="deleteInquiry(<?php echo $inquiry['id']; ?>)">
                            <i class="bi bi-trash"></i>
                        </button>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php if (empty($inquiries)): ?>
                <tr><td colspan="7" class="text-center py-4 text-muted">No inquiries found</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<script>
function deleteInquiry(inquiryId) {
    if (confirm('Are you sure you want to delete this inquiry? This action cannot be undone.')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = 'inquiry-delete.php';
        
        const csrfToken = document.createElement('input');
        csrfToken.type = 'hidden';
        csrfToken.name = 'csrf_token';
        csrfToken.value = '<?php echo generate_csrf_token(); ?>';
        
        const inquiryIdField = document.createElement('input');
        inquiryIdField.type = 'hidden';
        inquiryIdField.name = 'inquiry_id';
        inquiryIdField.value = inquiryId;
        
        form.appendChild(csrfToken);
        form.appendChild(inquiryIdField);
        document.body.appendChild(form);
        form.submit();
    }
}
</script>

<?php include __DIR__ . '/includes/footer.php'; ?>
