<?php
/**
 * Admin - Delete Contact Inquiry
 */
require_once __DIR__ . '/../config.php';
require_admin_login();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    redirect(BASE_URL . 'admin/inquiries.php', 'error', 'Invalid request');
}

if (!verify_csrf_token($_POST['csrf_token'] ?? '')) {
    redirect(BASE_URL . 'admin/inquiries.php', 'error', 'Invalid security token');
}

$inquiry_id = intval($_POST['inquiry_id'] ?? 0);

if (!$inquiry_id) {
    redirect(BASE_URL . 'admin/inquiries.php', 'error', 'Invalid inquiry ID');
}

try {
    // Check if inquiry exists
    $stmt = db()->prepare("SELECT name FROM contact_inquiries WHERE id = ?");
    $stmt->execute([$inquiry_id]);
    $inquiry = $stmt->fetch();
    
    if (!$inquiry) {
        redirect(BASE_URL . 'admin/inquiries.php', 'error', 'Inquiry not found');
    }
    
    // Delete inquiry
    $stmt = db()->prepare("DELETE FROM contact_inquiries WHERE id = ?");
    $stmt->execute([$inquiry_id]);
    
    // Log activity
    log_activity('inquiry_deleted', "Deleted contact inquiry from: {$inquiry['name']}", $_SESSION['admin_id'], 'admin');
    
    redirect(BASE_URL . 'admin/inquiries.php', 'success', 'Inquiry deleted successfully');
    
} catch (PDOException $e) {
    error_log("Delete inquiry error: " . $e->getMessage());
    redirect(BASE_URL . 'admin/inquiries.php', 'error', 'Failed to delete inquiry');
}
