<?php
/**
 * Hostxolo - Admin Logout
 */
require_once __DIR__ . '/../config.php';

// Log the logout activity
if (is_admin_logged_in() && isset($_SESSION['admin_id'])) {
    log_activity('admin_logout', 'Admin logged out', $_SESSION['admin_id'], 'admin');
}

// Clear all session data
$_SESSION = array();

// Destroy the session cookie
if (isset($_COOKIE[session_name()])) {
    setcookie(session_name(), '', time() - 3600, '/');
}

// Destroy the session
session_destroy();

// Redirect to admin login
redirect(BASE_URL . 'admin/login.php');
