<?php
/**
 * Admin - Edit CMS Page
 */
require_once __DIR__ . '/../config.php';
require_admin_login();

$page_title = 'Edit CMS Page';
$page_id = intval($_GET['id'] ?? 0);
$page_data = null;
$errors = [];

if ($page_id) {
    try {
        $stmt = db()->prepare("SELECT * FROM pages WHERE id = ?");
        $stmt->execute([$page_id]);
        $page_data = $stmt->fetch();
    } catch (PDOException $e) {}
}

if (!$page_data) {
    redirect(BASE_URL . 'admin/pages.php', 'error', 'Page not found');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verify_csrf_token($_POST['csrf_token'] ?? '')) {
        $errors[] = 'Invalid security token';
    } else {
        $title = sanitize($_POST['title'] ?? '');
        $content = $_POST['content'] ?? '';
        $meta_title = sanitize($_POST['meta_title'] ?? '');
        $meta_description = sanitize($_POST['meta_description'] ?? '');
        $status = isset($_POST['status']) ? 1 : 0;
        
        if (empty($title)) $errors[] = 'Page title is required';
        
        if (empty($errors)) {
            try {
                $stmt = db()->prepare("UPDATE pages SET 
                    title = ?, content = ?, meta_title = ?, meta_description = ?, status = ?, updated_at = NOW()
                    WHERE id = ?");
                $stmt->execute([$title, $content, $meta_title, $meta_description, $status, $page_id]);
                
                $stmt = db()->prepare("SELECT * FROM pages WHERE id = ?");
                $stmt->execute([$page_id]);
                $page_data = $stmt->fetch();
                
                $success = 'Page updated successfully';
            } catch (PDOException $e) {
                $errors[] = 'Failed to update page: ' . $e->getMessage();
            }
        }
    }
}

$csrf_token = generate_csrf_token();
include __DIR__ . '/includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="fw-bold mb-0">Edit CMS Page</h2>
    <a href="pages.php" class="btn btn-outline-secondary"><i class="bi bi-arrow-left me-2"></i>Back</a>
</div>

<?php if (!empty($errors)): ?>
    <div class="alert alert-danger"><?php foreach ($errors as $error): ?><p class="mb-0"><?php echo $error; ?></p><?php endforeach; ?></div>
<?php endif; ?>
<?php if (isset($success)): ?>
    <div class="alert alert-success"><?php echo $success; ?></div>
<?php endif; ?>

<div class="card border-0 shadow-sm">
    <div class="card-body p-4">
        <form method="POST">
            <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">Page Title <span class="text-danger">*</span></label>
                    <input type="text" name="title" class="form-control" value="<?php echo $page_data['title']; ?>" required>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Slug</label>
                    <input type="text" class="form-control" value="<?php echo $page_data['slug']; ?>" disabled>
                    <small class="text-muted">Slug cannot be changed</small>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Meta Title</label>
                    <input type="text" name="meta_title" class="form-control" value="<?php echo $page_data['meta_title']; ?>">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Meta Description</label>
                    <input type="text" name="meta_description" class="form-control" value="<?php echo $page_data['meta_description']; ?>">
                </div>
                <div class="col-12">
                    <label class="form-label">Content</label>
                    <textarea name="content" class="form-control" rows="10"><?php echo $page_data['content']; ?></textarea>
                </div>
                <div class="col-12">
                    <div class="form-check">
                        <input type="checkbox" name="status" class="form-check-input" id="statusCheck" <?php echo $page_data['status'] ? 'checked' : ''; ?>>
                        <label class="form-check-label" for="statusCheck">Active</label>
                    </div>
                </div>
            </div>
            <div class="mt-4">
                <button type="submit" class="btn btn-primary"><i class="bi bi-save me-2"></i>Update Page</button>
                <a href="pages.php" class="btn btn-outline-secondary ms-2">Cancel</a>
            </div>
        </form>
    </div>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>
