<?php
/**
 * Admin - CMS Pages
 */
require_once __DIR__ . '/../config.php';
require_admin_login();

$page_title = 'Pages';

$pages = [];
try {
    $stmt = db()->query("SELECT * FROM pages ORDER BY title ASC");
    $pages = $stmt->fetchAll();
} catch (PDOException $e) {}

include __DIR__ . '/includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="fw-bold mb-0">CMS Pages</h2>
    <a href="page-add.php" class="btn btn-primary"><i class="bi bi-plus-lg me-2"></i>Add Page</a>
</div>

<div class="card border-0 shadow-sm">
    <div class="table-responsive">
        <table class="table table-hover mb-0">
            <thead class="table-light">
                <tr>
                    <th>Title</th>
                    <th>Slug</th>
                    <th>Meta Title</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($pages as $page): ?>
                <tr>
                    <td><?php echo $page['title']; ?></td>
                    <td><code><?php echo $page['slug']; ?></code></td>
                    <td><?php echo substr($page['meta_title'], 0, 40); ?>...</td>
                    <td>
                        <span class="badge bg-<?php echo $page['status'] ? 'success' : 'secondary'; ?>">
                            <?php echo $page['status'] ? 'Active' : 'Inactive'; ?>
                        </span>
                    </td>
                    <td>
                        <a href="page-edit.php?id=<?php echo $page['id']; ?>" class="btn btn-sm btn-outline-primary">
                            <i class="bi bi-pencil"></i>
                        </a>
                        <button class="btn btn-sm btn-outline-danger" onclick="deletePage(<?php echo $page['id']; ?>)">
                            <i class="bi bi-trash"></i>
                        </button>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php if (empty($pages)): ?>
                <tr><td colspan="5" class="text-center py-4 text-muted">No pages found</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<script>
function deletePage(pageId) {
    if (confirm('Are you sure you want to delete this page? This action cannot be undone.')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = 'page-delete.php';
        
        const csrfToken = document.createElement('input');
        csrfToken.type = 'hidden';
        csrfToken.name = 'csrf_token';
        csrfToken.value = '<?php echo generate_csrf_token(); ?>';
        
        const pageIdField = document.createElement('input');
        pageIdField.type = 'hidden';
        pageIdField.name = 'page_id';
        pageIdField.value = pageId;
        
        form.appendChild(csrfToken);
        form.appendChild(pageIdField);
        document.body.appendChild(form);
        form.submit();
    }
}
</script>

<?php include __DIR__ . '/includes/footer.php'; ?>
