<?php
/**
 * Admin - Payment Settings
 */
require_once __DIR__ . '/../config.php';
require_admin_login();

$page_title = 'Payment Settings';

$success = '';
$error = '';

include __DIR__ . '/includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="fw-bold mb-0">Payment Settings</h2>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-body">
        <form method="POST">
            <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">
            
            <h5 class="mb-3">Razorpay (India)</h5>
            <div class="row g-3 mb-4">
                <div class="col-md-6">
                    <label class="form-label">Key ID</label>
                    <input type="text" name="razorpay_key_id" class="form-control" placeholder="rzp_test_...">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Key Secret</label>
                    <input type="password" name="razorpay_key_secret" class="form-control" placeholder="Enter secret key">
                </div>
            </div>
            
            <h5 class="mb-3">Stripe (International)</h5>
            <div class="row g-3 mb-4">
                <div class="col-md-6">
                    <label class="form-label">Publishable Key</label>
                    <input type="text" name="stripe_publishable_key" class="form-control" placeholder="pk_test_...">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Secret Key</label>
                    <input type="password" name="stripe_secret_key" class="form-control" placeholder="sk_test_...">
                </div>
            </div>
            
            <h5 class="mb-3">PayPal</h5>
            <div class="row g-3 mb-4">
                <div class="col-md-6">
                    <label class="form-label">Client ID</label>
                    <input type="text" name="paypal_client_id" class="form-control">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Mode</label>
                    <select name="paypal_mode" class="form-select">
                        <option value="sandbox">Sandbox (Test)</option>
                        <option value="live">Live (Production)</option>
                    </select>
                </div>
            </div>
            
            <div class="alert alert-info">
                <i class="bi bi-info-circle me-2"></i>
                Note: Update these keys in the config.php file directly.
            </div>
            
            <div class="mt-4">
                <button type="submit" class="btn btn-primary" disabled>
                    <i class="bi bi-save me-2"></i>Save Settings (Edit config.php)
                </button>
            </div>
        </form>
    </div>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>
