<?php
/**
 * Admin - Add Subscription Plan
 */
require_once __DIR__ . '/../config.php';
require_admin_login();

$page_title = 'Add Subscription Plan';
$errors = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verify_csrf_token($_POST['csrf_token'] ?? '')) {
        $errors[] = 'Invalid security token';
    } else {
        $name = sanitize($_POST['name'] ?? '');
        $slug = create_slug($name);
        $description = sanitize($_POST['description'] ?? '');
        $monthly_price = floatval($_POST['monthly_price'] ?? 0);
        $yearly_price = floatval($_POST['yearly_price'] ?? 0);
        $is_featured = isset($_POST['is_featured']) ? 1 : 0;
        $status = isset($_POST['status']) ? 1 : 0;
        
        if (empty($name)) $errors[] = 'Plan name is required';
        
        if (empty($errors)) {
            try {
                $stmt = db()->prepare("INSERT INTO subscription_plans 
                    (name, slug, description, monthly_price, yearly_price, is_featured, status, created_at, updated_at)
                    VALUES (?, ?, ?, ?, ?, ?, ?, NOW(), NOW())");
                $stmt->execute([$name, $slug, $description, $monthly_price, $yearly_price, $is_featured, $status]);
                redirect(BASE_URL . 'admin/plans.php', 'success', 'Plan added successfully');
            } catch (PDOException $e) {
                $errors[] = 'Failed to add plan: ' . $e->getMessage();
            }
        }
    }
}

$csrf_token = generate_csrf_token();
include __DIR__ . '/includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="fw-bold mb-0">Add Subscription Plan</h2>
    <a href="plans.php" class="btn btn-outline-secondary"><i class="bi bi-arrow-left me-2"></i>Back</a>
</div>

<?php if (!empty($errors)): ?>
    <div class="alert alert-danger"><?php foreach ($errors as $error): ?><p class="mb-0"><?php echo $error; ?></p><?php endforeach; ?></div>
<?php endif; ?>

<div class="card border-0 shadow-sm">
    <div class="card-body p-4">
        <form method="POST">
            <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">Plan Name <span class="text-danger">*</span></label>
                    <input type="text" name="name" class="form-control" required>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Monthly Price</label>
                    <input type="number" name="monthly_price" class="form-control" step="0.01" value="0">
                </div>
                <div class="col-md-3">
                    <label class="form-label">Yearly Price</label>
                    <input type="number" name="yearly_price" class="form-control" step="0.01" value="0">
                </div>
                <div class="col-12">
                    <label class="form-label">Description</label>
                    <textarea name="description" class="form-control" rows="3"></textarea>
                </div>
                <div class="col-12">
                    <div class="form-check">
                        <input type="checkbox" name="is_featured" class="form-check-input" id="featuredCheck">
                        <label class="form-check-label" for="featuredCheck">Featured Plan</label>
                    </div>
                </div>
                <div class="col-12">
                    <div class="form-check">
                        <input type="checkbox" name="status" class="form-check-input" id="statusCheck" checked>
                        <label class="form-check-label" for="statusCheck">Active</label>
                    </div>
                </div>
            </div>
            <div class="mt-4">
                <button type="submit" class="btn btn-primary"><i class="bi bi-save me-2"></i>Save Plan</button>
                <a href="plans.php" class="btn btn-outline-secondary ms-2">Cancel</a>
            </div>
        </form>
    </div>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>
