<?php
/**
 * Admin - Subscription Plans
 */
require_once __DIR__ . '/../config.php';
require_admin_login();

$page_title = 'Subscription Plans';

$plans = [];
try {
    $stmt = db()->query("SELECT * FROM subscription_plans ORDER BY monthly_price ASC");
    $plans = $stmt->fetchAll();
} catch (PDOException $e) {}

include __DIR__ . '/includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="fw-bold mb-0">Subscription Plans</h2>
    <a href="plan-add.php" class="btn btn-primary"><i class="bi bi-plus-lg me-2"></i>Add Plan</a>
</div>

<div class="row g-4">
    <?php foreach ($plans as $plan): ?>
    <div class="col-md-4">
        <div class="card h-100 border-0 shadow-sm">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start mb-3">
                    <h5 class="card-title fw-bold mb-0"><?php echo $plan['name']; ?></h5>
                    <span class="badge bg-<?php echo $plan['status'] ? 'success' : 'secondary'; ?>">
                        <?php echo $plan['status'] ? 'Active' : 'Inactive'; ?>
                    </span>
                </div>
                <p class="text-muted small"><?php echo substr($plan['description'], 0, 100); ?>...</p>
                <div class="d-flex justify-content-between mt-3">
                    <div>
                        <small class="text-muted d-block">Monthly</small>
                        <span class="fw-bold"><?php echo format_currency($plan['monthly_price']); ?></span>
                    </div>
                    <div>
                        <small class="text-muted d-block">Yearly</small>
                        <span class="fw-bold"><?php echo format_currency($plan['yearly_price']); ?></span>
                    </div>
                </div>
            </div>
            <div class="card-footer bg-white border-top-0">
                <div class="btn-group w-100" role="group">
                    <a href="plan-edit.php?id=<?php echo $plan['id']; ?>" class="btn btn-outline-primary btn-sm">
                        <i class="bi bi-pencil me-1"></i>Edit
                    </a>
                    <button class="btn btn-outline-danger btn-sm" onclick="deletePlan(<?php echo $plan['id']; ?>)">
                        <i class="bi bi-trash me-1"></i>Delete
                    </button>
                </div>
            </div>
        </div>
    </div>
    <?php endforeach; ?>
    <?php if (empty($plans)): ?>
    <div class="col-12 text-center py-5 text-muted">No plans found</div>
    <?php endif; ?>
</div>

<script>
function deletePlan(planId) {
    if (confirm('Are you sure you want to delete this plan? This action cannot be undone.')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = 'plan-delete.php';
        
        const csrfToken = document.createElement('input');
        csrfToken.type = 'hidden';
        csrfToken.name = 'csrf_token';
        csrfToken.value = '<?php echo generate_csrf_token(); ?>';
        
        const planIdField = document.createElement('input');
        planIdField.type = 'hidden';
        planIdField.name = 'plan_id';
        planIdField.value = planId;
        
        form.appendChild(csrfToken);
        form.appendChild(planIdField);
        document.body.appendChild(form);
        form.submit();
    }
}
</script>

<?php include __DIR__ . '/includes/footer.php'; ?>
