<?php
/**
 * Admin - Add Service
 */
require_once __DIR__ . '/../config.php';
require_admin_login();

$page_title = 'Add Service';

$success = '';
$errors = [];

// Get categories
$categories = [];
try {
    $stmt = db()->query("SELECT * FROM service_categories WHERE status = 1 ORDER BY name");
    $categories = $stmt->fetchAll();
} catch (PDOException $e) {}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verify_csrf_token($_POST['csrf_token'] ?? '')) {
        $errors[] = 'Invalid security token';
    } else {
        $name = sanitize($_POST['name'] ?? '');
        $slug = create_slug($name);
        $description = sanitize($_POST['description'] ?? '');
        $short_description = sanitize($_POST['short_description'] ?? '');
        $category_id = intval($_POST['category_id'] ?? 0);
        $icon = sanitize($_POST['icon'] ?? 'briefcase');
        $price = floatval($_POST['price'] ?? 0);
        $button_link = sanitize($_POST['button_link'] ?? '');
        $button_text = sanitize($_POST['button_text'] ?? 'Learn More');
        $status = isset($_POST['status']) ? 1 : 0;
        
        if (empty($name)) $errors[] = 'Service name is required';
        if (empty($description)) $errors[] = 'Description is required';
        
        if (empty($errors)) {
            try {
                $stmt = db()->prepare("INSERT INTO services 
                    (category_id, name, slug, description, short_description, icon, price_starting_from, button_link, button_text, status, created_at, updated_at)
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), NOW())");
                $stmt->execute([$category_id, $name, $slug, $description, $short_description, $icon, $price, $button_link, $button_text, $status]);
                
                redirect(BASE_URL . 'admin/services.php', 'success', 'Service added successfully');
            } catch (PDOException $e) {
                error_log("Service add error: " . $e->getMessage());
                $errors[] = 'Failed to add service: ' . $e->getMessage();
            }
        }
    }
}

$csrf_token = generate_csrf_token();

include __DIR__ . '/includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="fw-bold mb-0">Add Service</h2>
    <a href="services.php" class="btn btn-outline-secondary">
        <i class="bi bi-arrow-left me-2"></i>Back
    </a>
</div>

<?php if (!empty($errors)): ?>
    <div class="alert alert-danger">
        <?php foreach ($errors as $error): ?>
            <p class="mb-0"><?php echo $error; ?></p>
        <?php endforeach; ?>
    </div>
<?php endif; ?>

<div class="card border-0 shadow-sm">
    <div class="card-body p-4">
        <form method="POST">
            <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
            
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">Service Name <span class="text-danger">*</span></label>
                    <input type="text" name="name" class="form-control" required>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Category</label>
                    <select name="category_id" class="form-select">
                        <option value="">Select Category</option>
                        <?php foreach ($categories as $cat): ?>
                        <option value="<?php echo $cat['id']; ?>"><?php echo $cat['name']; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Icon (Bootstrap Icon name)</label>
                    <input type="text" name="icon" class="form-control" value="briefcase" placeholder="e.g., briefcase, globe, phone">
                    <small class="text-muted">Find icons at: https://icons.getbootstrap.com/</small>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Price (0 for free/contact)</label>
                    <input type="number" name="price" class="form-control" step="0.01" value="0">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Button Text</label>
                    <input type="text" name="button_text" class="form-control" value="Learn More" placeholder="e.g., Learn More, Get Started">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Button Link (URL)</label>
                    <input type="text" name="button_link" class="form-control" placeholder="e.g., contact.php or https://example.com">
                    <small class="text-muted">Leave empty for default service page</small>
                </div>
                <div class="col-12">
                    <label class="form-label">Short Description</label>
                    <input type="text" name="short_description" class="form-control" maxlength="255">
                </div>
                <div class="col-12">
                    <label class="form-label">Full Description <span class="text-danger">*</span></label>
                    <textarea name="description" class="form-control" rows="6" required></textarea>
                </div>
                <div class="col-12">
                    <div class="form-check">
                        <input type="checkbox" name="status" class="form-check-input" id="statusCheck" checked>
                        <label class="form-check-label" for="statusCheck">Active</label>
                    </div>
                </div>
            </div>
            
            <div class="mt-4">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-save me-2"></i>Save Service
                </button>
                <a href="services.php" class="btn btn-outline-secondary ms-2">Cancel</a>
            </div>
        </form>
    </div>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>
