<?php
/**
 * Admin - Service Bulk Actions
 */
require_once __DIR__ . '/../config.php';
require_admin_login();

$action = $_POST['action'] ?? '';
$ids = $_POST['ids'] ?? [];

if (empty($ids)) {
    redirect(BASE_URL . 'admin/services.php', 'error', 'No services selected');
}

if (!in_array($action, ['activate', 'deactivate', 'delete'])) {
    redirect(BASE_URL . 'admin/services.php', 'error', 'Invalid action');
}

$ids = array_map('intval', $ids);
$id_list = implode(',', $ids);

try {
    switch ($action) {
        case 'activate':
            $stmt = db()->prepare("UPDATE services SET status = 1, updated_at = NOW() WHERE id IN ($id_list)");
            $stmt->execute();
            log_activity('services_activated', "Activated services: $id_list", $_SESSION['admin_id'], 'admin');
            redirect(BASE_URL . 'admin/services.php', 'success', count($ids) . ' service(s) activated');
            break;
            
        case 'deactivate':
            $stmt = db()->prepare("UPDATE services SET status = 0, updated_at = NOW() WHERE id IN ($id_list)");
            $stmt->execute();
            log_activity('services_deactivated', "Deactivated services: $id_list", $_SESSION['admin_id'], 'admin');
            redirect(BASE_URL . 'admin/services.php', 'success', count($ids) . ' service(s) deactivated');
            break;
            
        case 'delete':
            $stmt = db()->prepare("DELETE FROM services WHERE id IN ($id_list)");
            $stmt->execute();
            log_activity('services_deleted', "Deleted services: $id_list", $_SESSION['admin_id'], 'admin');
            redirect(BASE_URL . 'admin/services.php', 'success', count($ids) . ' service(s) deleted');
            break;
    }
} catch (PDOException $e) {
    error_log("Bulk action error: " . $e->getMessage());
    redirect(BASE_URL . 'admin/services.php', 'error', 'Action failed');
}
