<?php
/**
 * Admin - Delete Service
 */
require_once __DIR__ . '/../config.php';
require_admin_login();

$id = intval($_GET['id'] ?? 0);

if (!$id) {
    redirect(BASE_URL . 'admin/services.php', 'error', 'Invalid service ID');
}

try {
    $stmt = db()->prepare("DELETE FROM services WHERE id = ?");
    $stmt->execute([$id]);
    
    log_activity('service_deleted', "Deleted service ID: $id", $_SESSION['admin_id'], 'admin');
    redirect(BASE_URL . 'admin/services.php', 'success', 'Service deleted successfully');
} catch (PDOException $e) {
    error_log("Delete service error: " . $e->getMessage());
    redirect(BASE_URL . 'admin/services.php', 'error', 'Failed to delete service');
}
