<?php
/**
 * Admin - Services Management
 */
require_once __DIR__ . '/../config.php';
require_admin_login();

$page_title = 'Services';

$services = [];
try {
    $stmt = db()->query("SELECT s.*, sc.name as category_name 
                        FROM services s
                        LEFT JOIN service_categories sc ON s.category_id = sc.id
                        ORDER BY s.created_at DESC");
    $services = $stmt->fetchAll();
} catch (PDOException $e) {}

include __DIR__ . '/includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="fw-bold mb-0">Services</h2>
    <a href="service-add.php" class="btn btn-primary"><i class="bi bi-plus-lg me-2"></i>Add Service</a>
</div>

<div class="card border-0 shadow-sm">
    <form method="POST" action="service-bulk-action.php" id="bulk-form">
        <div class="card-header bg-white">
            <div class="d-flex justify-content-between align-items-center">
                <div class="btn-group">
                    <button type="submit" name="action" value="activate" class="btn btn-outline-success btn-sm">
                        <i class="bi bi-check-circle me-1"></i>Activate
                    </button>
                    <button type="submit" name="action" value="deactivate" class="btn btn-outline-warning btn-sm">
                        <i class="bi bi-pause-circle me-1"></i>Deactivate
                    </button>
                    <button type="submit" name="action" value="delete" class="btn btn-outline-danger btn-sm" onclick="return confirm('Delete selected services?')">
                        <i class="bi bi-trash me-1"></i>Delete
                    </button>
                </div>
            </div>
        </div>
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th><input type="checkbox" class="form-check-input" id="select-all"></th>
                        <th>ID</th>
                        <th>Icon</th>
                        <th>Name</th>
                        <th>Category</th>
                        <th>Price</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($services as $service): ?>
                    <tr>
                        <td><input type="checkbox" class="form-check-input row-checkbox" name="ids[]" value="<?php echo $service['id']; ?>"></td>
                        <td><?php echo $service['id']; ?></td>
                        <td><i class="bi bi-<?php echo $service['icon'] ?? 'briefcase'; ?>"></i></td>
                        <td><?php echo $service['name']; ?></td>
                        <td><?php echo $service['category_name'] ?? 'Uncategorized'; ?></td>
                        <td><?php echo ($service['price_starting_from'] ?? 0) ? format_currency($service['price_starting_from']) : '-'; ?></td>
                        <td>
                            <span class="badge bg-<?php echo $service['status'] ? 'success' : 'secondary'; ?>">
                                <?php echo $service['status'] ? 'Active' : 'Inactive'; ?>
                            </span>
                        </td>
                        <td>
                            <a href="service-edit.php?id=<?php echo $service['id']; ?>" class="btn btn-sm btn-outline-primary">
                                <i class="bi bi-pencil"></i>
                            </a>
                            <a href="service-delete.php?id=<?php echo $service['id']; ?>" class="btn btn-sm btn-outline-danger" onclick="return confirm('Delete this service?')">
                                <i class="bi bi-trash"></i>
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                    <?php if (empty($services)): ?>
                    <tr><td colspan="8" class="text-center py-4 text-muted">No services found</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </form>
</div>

<script>
document.getElementById('select-all').addEventListener('change', function() {
    document.querySelectorAll('.row-checkbox').forEach(cb => cb.checked = this.checked);
});
</script>

<?php include __DIR__ . '/includes/footer.php'; ?>
