<?php
/**
 * Admin - Site Pages & Content Management
 */
require_once __DIR__ . '/../config.php';
require_admin_login();

$page_title = 'Site Management';
$active_tab = $_GET['tab'] ?? 'homepage';

$success = '';
$errors = [];

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verify_csrf_token($_POST['csrf_token'] ?? '')) {
        $errors[] = 'Invalid security token';
    } else {
        $tab = $_POST['tab'] ?? 'homepage';
        
        // Handle hero image upload
        if ($tab === 'homepage' && !empty($_FILES['hero_image']['name'])) {
            $upload_dir = UPLOADS_PATH . 'hero/';
            
            // Check if main uploads directory exists and is writable
            if (!is_dir(UPLOADS_PATH)) {
                $errors[] = 'Uploads directory does not exist. Please create: ' . UPLOADS_PATH;
            } elseif (!is_writable(UPLOADS_PATH)) {
                $errors[] = 'Uploads directory is not writable. Please fix permissions on: ' . UPLOADS_PATH;
            } else {
                // Try to create hero subdirectory
                if (!is_dir($upload_dir)) {
                    @mkdir($upload_dir, 0777, true);
                    // Suppress errors and check if it worked
                    if (!is_dir($upload_dir)) {
                        // Fallback: use main uploads directory
                        $upload_dir = UPLOADS_PATH;
                    }
                }
                
                $file_name = 'hero-' . time() . '-' . preg_replace('/[^a-zA-Z0-9.-]/', '-', basename($_FILES['hero_image']['name']));
                $target_file = $upload_dir . $file_name;
                
                $allowed_types = ['image/jpeg', 'image/png', 'image/gif', 'image/webp', 'image/svg+xml'];
                $file_type = $_FILES['hero_image']['type'];
                
                if (!in_array($file_type, $allowed_types)) {
                    $errors[] = 'Only JPG, PNG, GIF, WebP, and SVG images are allowed';
                } elseif ($_FILES['hero_image']['size'] > 5 * 1024 * 1024) {
                    $errors[] = 'Image size should not exceed 5MB';
                } else {
                    if (move_uploaded_file($_FILES['hero_image']['tmp_name'], $target_file)) {
                        // Delete old image if exists
                        $old_image = get_system_setting('homepage_hero_image');
                        if ($old_image && file_exists(UPLOADS_PATH . $old_image)) {
                            @unlink(UPLOADS_PATH . $old_image);
                        }
                        // Store relative path from uploads folder
                        $relative_path = ($upload_dir === UPLOADS_PATH) ? $file_name : 'hero/' . $file_name;
                        update_system_setting('homepage_hero_image', $relative_path, 'string');
                    } else {
                        $errors[] = 'Failed to upload image. Please check directory permissions.';
                    }
                }
            }
        }
        
        if (empty($errors)) {
            switch ($tab) {
                case 'homepage':
                    update_system_setting('homepage_hero_title', $_POST['hero_title'] ?? '', 'string');
                    update_system_setting('homepage_hero_subtitle', $_POST['hero_subtitle'] ?? '', 'string');
                    update_system_setting('homepage_hero_content', $_POST['hero_content'] ?? '', 'string');
                    update_system_setting('homepage_hero_button_text', $_POST['hero_button_text'] ?? 'Get Started', 'string');
                    update_system_setting('homepage_hero_button_link', $_POST['hero_button_link'] ?? 'plans.php', 'string');
                    update_system_setting('homepage_features_title', $_POST['features_title'] ?? 'Why Choose Us', 'string');
                    update_system_setting('homepage_services_title', $_POST['services_title'] ?? 'Our Services', 'string');
                    update_system_setting('homepage_software_title', $_POST['software_title'] ?? 'Our Software', 'string');
                    update_system_setting('homepage_testimonials_title', $_POST['testimonials_title'] ?? 'Customer Review', 'string');
                    update_system_setting('homepage_cta_title', $_POST['cta_title'] ?? 'Ready to Grow Your Business?', 'string');
                    update_system_setting('homepage_cta_subtitle', $_POST['cta_subtitle'] ?? '', 'string');
                    update_system_setting('homepage_cta_text', $_POST['cta_text'] ?? '', 'string');
                    update_system_setting('homepage_cta_button_text', $_POST['cta_button_text'] ?? 'Contact Us', 'string');
                    update_system_setting('homepage_cta_button_link', $_POST['cta_button_link'] ?? 'contact.php', 'string');
                    break;
                
                case 'site_info':
                    update_system_setting('site_name', $_POST['site_name'] ?? 'Hostxolo', 'string');
                    update_system_setting('site_tagline', $_POST['site_tagline'] ?? '', 'string');
                    update_system_setting('site_description', $_POST['site_description'] ?? '', 'string');
                    update_system_setting('contact_email', $_POST['contact_email'] ?? '', 'string');
                    update_system_setting('contact_phone', $_POST['contact_phone'] ?? '', 'string');
                    update_system_setting('contact_address', $_POST['contact_address'] ?? '', 'string');
                    update_system_setting('business_hours', $_POST['business_hours'] ?? '', 'string');
                    break;
                    
                case 'social':
                    update_system_setting('social_facebook', $_POST['facebook'] ?? '', 'string');
                    update_system_setting('social_twitter', $_POST['twitter'] ?? '', 'string');
                    update_system_setting('social_instagram', $_POST['instagram'] ?? '', 'string');
                    update_system_setting('social_linkedin', $_POST['linkedin'] ?? '', 'string');
                    update_system_setting('social_youtube', $_POST['youtube'] ?? '', 'string');
                    update_system_setting('social_whatsapp', $_POST['whatsapp'] ?? '', 'string');
                    update_system_setting('social_telegram', $_POST['telegram'] ?? '', 'string');
                    break;
                    
                case 'footer':
                    update_system_setting('footer_about_text', $_POST['footer_about_text'] ?? '', 'string');
                    update_system_setting('footer_copyright', $_POST['footer_copyright'] ?? '', 'string');
                    update_system_setting('footer_show_services', $_POST['footer_show_services'] ?? '1', 'string');
                    update_system_setting('footer_show_software', $_POST['footer_show_software'] ?? '1', 'string');
                    update_system_setting('footer_show_newsletter', $_POST['footer_show_newsletter'] ?? '1', 'string');
                    update_system_setting('footer_services_limit', $_POST['footer_services_limit'] ?? '5', 'string');
                    update_system_setting('footer_software_limit', $_POST['footer_software_limit'] ?? '5', 'string');
                    
                    // Process quick links
                    $quick_links = [];
                    $quick_link_titles = $_POST['quick_link_title'] ?? [];
                    $quick_link_urls = $_POST['quick_link_url'] ?? [];
                    
                    foreach ($quick_link_titles as $index => $title) {
                        $title = trim($title);
                        $url = trim($quick_link_urls[$index] ?? '');
                        
                        if (!empty($title) && !empty($url)) {
                            $quick_links[] = [
                                'title' => $title,
                                'url' => $url
                            ];
                        }
                    }
                    
                    update_system_setting('footer_quick_links', json_encode($quick_links), 'json');
                    
                    // Process additional links
                    $additional_links = [];
                    $additional_link_titles = $_POST['additional_link_title'] ?? [];
                    $additional_link_urls = $_POST['additional_link_url'] ?? [];
                    $additional_link_sections = $_POST['additional_link_section'] ?? [];
                    
                    foreach ($additional_link_titles as $index => $title) {
                        $title = trim($title);
                        $url = trim($additional_link_urls[$index] ?? '');
                        $section = trim($additional_link_sections[$index] ?? 'services');
                        
                        if (!empty($title) && !empty($url)) {
                            $additional_links[] = [
                                'title' => $title,
                                'url' => $url,
                                'section' => $section
                            ];
                        }
                    }
                    
                    update_system_setting('footer_additional_links', json_encode($additional_links), 'json');
                    break;
            }
        }
        
        $success = 'Settings saved successfully';
    }
}

// Get current settings
$settings = [];
$keys = [
    'homepage_hero_title', 'homepage_hero_subtitle', 'homepage_hero_content', 'homepage_hero_button_text', 'homepage_hero_button_link', 'homepage_hero_image',
    'homepage_features_title', 'homepage_services_title', 'homepage_software_title', 'homepage_testimonials_title',
    'homepage_cta_title', 'homepage_cta_subtitle', 'homepage_cta_text', 'homepage_cta_button_text', 'homepage_cta_button_link',
    'site_name', 'site_tagline', 'site_description', 'contact_email', 'contact_phone', 'contact_address', 'business_hours',
    'social_facebook', 'social_twitter', 'social_instagram', 'social_linkedin', 'social_youtube', 'social_whatsapp', 'social_telegram',
    'footer_about_text', 'footer_copyright', 'footer_show_services', 'footer_show_software', 'footer_show_newsletter',
    'footer_services_limit', 'footer_software_limit', 'footer_quick_links', 'footer_additional_links'
];

foreach ($keys as $key) {
    $settings[$key] = get_system_setting($key);
}

$csrf_token = generate_csrf_token();
include __DIR__ . '/includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="fw-bold mb-0">Site Management</h2>
</div>

<?php if (!empty($errors)): ?>
    <div class="alert alert-danger alert-dismissible fade show">
        <?php foreach ($errors as $error): ?><p class="mb-0"><?php echo $error; ?></p><?php endforeach; ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if ($success): ?>
    <div class="alert alert-success alert-dismissible fade show">
        <i class="bi bi-check-circle-fill me-2"></i><?php echo $success; ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="row">
    <div class="col-md-3">
        <div class="list-group">
            <a href="?tab=homepage" class="list-group-item list-group-item-action <?php echo $active_tab === 'homepage' ? 'active' : ''; ?>">
                <i class="bi bi-house-door me-2"></i>Homepage
            </a>
            <a href="?tab=site_info" class="list-group-item list-group-item-action <?php echo $active_tab === 'site_info' ? 'active' : ''; ?>">
                <i class="bi bi-info-circle me-2"></i>Site Information
            </a>
            <a href="?tab=social" class="list-group-item list-group-item-action <?php echo $active_tab === 'social' ? 'active' : ''; ?>">
                <i class="bi bi-share me-2"></i>Social Media
            </a>
            <a href="?tab=footer" class="list-group-item list-group-item-action <?php echo $active_tab === 'footer' ? 'active' : ''; ?>">
                <i class="bi bi-layout-text-sidebar-reverse me-2"></i>Footer
            </a>
        </div>
        
        <div class="mt-4">
            <a href="pages.php" class="btn btn-outline-primary w-100 mb-2">
                <i class="bi bi-file-earmark-text me-2"></i>CMS Pages
            </a>
        </div>
    </div>
    
    <div class="col-md-9">
        <div class="card border-0 shadow-sm">
            <div class="card-body p-4">
                <form method="POST" enctype="multipart/form-data">
                    <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
                    <input type="hidden" name="tab" value="<?php echo $active_tab; ?>">
                    
                    <?php if ($active_tab === 'homepage'): ?>
                        <h5 class="mb-3"><i class="bi bi-house-door me-2"></i>Homepage Sections</h5>
                        
                        <div class="mb-4">
                            <h6 class="text-primary">Hero Section</h6>
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label class="form-label">Hero Title</label>
                                    <input type="text" name="hero_title" class="form-control" value="<?php echo $settings['homepage_hero_title']; ?>">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Hero Subtitle</label>
                                    <input type="text" name="hero_subtitle" class="form-control" value="<?php echo $settings['homepage_hero_subtitle']; ?>">
                                </div>
                                <div class="col-12">
                                    <label class="form-label">Hero Content/Description</label>
                                    <textarea name="hero_content" class="form-control" rows="2"><?php echo $settings['homepage_hero_content']; ?></textarea>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Button Text</label>
                                    <input type="text" name="hero_button_text" class="form-control" value="<?php echo $settings['homepage_hero_button_text'] ?? 'Get Started'; ?>">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Button Link</label>
                                    <input type="text" name="hero_button_link" class="form-control" value="<?php echo $settings['homepage_hero_button_link'] ?? 'plans.php'; ?>">
                                </div>
                                <div class="col-12">
                                    <label class="form-label">Hero Image</label>
                                    <?php if ($settings['homepage_hero_image']): ?>
                                        <div class="mb-2">
                                            <img src="<?php echo UPLOADS_URL . $settings['homepage_hero_image']; ?>" alt="Current Hero" class="img-thumbnail" style="max-height: 150px;">
                                            <p class="text-muted small">Current Image</p>
                                        </div>
                                    <?php endif; ?>
                                    <input type="file" name="hero_image" class="form-control" accept="image/*">
                                    <small class="text-muted">Upload JPG, PNG, GIF, WebP or SVG (max 5MB). Leave empty to keep current image.</small>
                                </div>
                            </div>
                        </div>
                        
                        <hr>
                        
                        <div class="mb-4">
                            <h6 class="text-primary">Section Titles</h6>
                            <div class="row g-3">
                                <div class="col-md-3">
                                    <label class="form-label">Features Title</label>
                                    <input type="text" name="features_title" class="form-control" value="<?php echo $settings['homepage_features_title'] ?? 'Why Choose Us'; ?>">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">Services Title</label>
                                    <input type="text" name="services_title" class="form-control" value="<?php echo $settings['homepage_services_title'] ?? 'Our Services'; ?>">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">Software Title</label>
                                    <input type="text" name="software_title" class="form-control" value="<?php echo $settings['homepage_software_title'] ?? 'Our Software'; ?>">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">Testimonials Title</label>
                                    <input type="text" name="testimonials_title" class="form-control" value="<?php echo $settings['homepage_testimonials_title'] ?? 'Customer Review'; ?>">
                                </div>
                            </div>
                        </div>
                        
                        <hr>
                        
                        <div class="mb-4">
                            <h6 class="text-primary">CTA Section</h6>
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label class="form-label">CTA Title</label>
                                    <input type="text" name="cta_title" class="form-control" value="<?php echo $settings['homepage_cta_title'] ?? 'Ready to Grow Your Business?'; ?>">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">CTA Subtitle</label>
                                    <input type="text" name="cta_subtitle" class="form-control" value="<?php echo $settings['homepage_cta_subtitle'] ?? ''; ?>">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">CTA Button Text</label>
                                    <input type="text" name="cta_button_text" class="form-control" value="<?php echo $settings['homepage_cta_button_text'] ?? 'Contact Us'; ?>">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">CTA Button Link</label>
                                    <input type="text" name="cta_button_link" class="form-control" value="<?php echo $settings['homepage_cta_button_link'] ?? 'contact.php'; ?>">
                                </div>
                                <div class="col-12">
                                    <label class="form-label">CTA Description</label>
                                    <textarea name="cta_text" class="form-control" rows="2"><?php echo $settings['homepage_cta_text']; ?></textarea>
                                </div>
                            </div>
                        </div>
                        
                    <?php elseif ($active_tab === 'site_info'): ?>
                        <h5 class="mb-3"><i class="bi bi-info-circle me-2"></i>Site Information</h5>
                        
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Site Name</label>
                                <input type="text" name="site_name" class="form-control" value="<?php echo $settings['site_name'] ?? 'Hostxolo'; ?>">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Site Tagline</label>
                                <input type="text" name="site_tagline" class="form-control" value="<?php echo $settings['site_tagline']; ?>">
                            </div>
                            <div class="col-12">
                                <label class="form-label">Site Description</label>
                                <textarea name="site_description" class="form-control" rows="3"><?php echo $settings['site_description']; ?></textarea>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Contact Email</label>
                                <input type="email" name="contact_email" class="form-control" value="<?php echo $settings['contact_email']; ?>">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Contact Phone</label>
                                <input type="text" name="contact_phone" class="form-control" value="<?php echo $settings['contact_phone']; ?>">
                            </div>
                            <div class="col-12">
                                <label class="form-label">Business Address</label>
                                <textarea name="contact_address" class="form-control" rows="2"><?php echo $settings['contact_address']; ?></textarea>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Business Hours</label>
                                <input type="text" name="business_hours" class="form-control" value="<?php echo $settings['business_hours']; ?>">
                            </div>
                        </div>
                        
                    <?php elseif ($active_tab === 'social'): ?>
                        <h5 class="mb-3"><i class="bi bi-share me-2"></i>Social Media Links</h5>
                        
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label"><i class="bi bi-facebook me-2 text-primary"></i>Facebook</label>
                                <input type="url" name="facebook" class="form-control" value="<?php echo $settings['social_facebook']; ?>" placeholder="https://facebook.com/...">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label"><i class="bi bi-twitter me-2 text-info"></i>Twitter</label>
                                <input type="url" name="twitter" class="form-control" value="<?php echo $settings['social_twitter']; ?>" placeholder="https://twitter.com/...">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label"><i class="bi bi-instagram me-2 text-danger"></i>Instagram</label>
                                <input type="url" name="instagram" class="form-control" value="<?php echo $settings['social_instagram']; ?>" placeholder="https://instagram.com/...">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label"><i class="bi bi-linkedin me-2 text-primary"></i>LinkedIn</label>
                                <input type="url" name="linkedin" class="form-control" value="<?php echo $settings['social_linkedin']; ?>" placeholder="https://linkedin.com/...">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label"><i class="bi bi-youtube me-2 text-danger"></i>YouTube</label>
                                <input type="url" name="youtube" class="form-control" value="<?php echo $settings['social_youtube']; ?>" placeholder="https://youtube.com/...">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label"><i class="bi bi-whatsapp me-2 text-success"></i>WhatsApp</label>
                                <input type="text" name="whatsapp" class="form-control" value="<?php echo $settings['social_whatsapp']; ?>" placeholder="+1234567890">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label"><i class="bi bi-telegram me-2 text-info"></i>Telegram</label>
                                <input type="text" name="telegram" class="form-control" value="<?php echo $settings['social_telegram']; ?>" placeholder="@username or link">
                            </div>
                        </div>
                        
                    <?php elseif ($active_tab === 'footer'): ?>
                        <h5 class="mb-3"><i class="bi bi-layout-text-sidebar-reverse me-2"></i>Footer Management</h5>
                        
                        <div class="mb-4">
                            <h6 class="text-primary">About Section</h6>
                            <div class="mb-3">
                                <label class="form-label">Footer About Text</label>
                                <textarea name="footer_about_text" class="form-control" rows="3" placeholder="Brief description about your company for footer"><?php echo $settings['footer_about_text'] ?? 'Your trusted partner for business growth. We provide comprehensive digital solutions to help your business thrive in the modern marketplace.'; ?></textarea>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Copyright Text</label>
                                <input type="text" name="footer_copyright" class="form-control" value="<?php echo $settings['footer_copyright'] ?? 'All rights reserved.'; ?>">
                            </div>
                        </div>
                        
                        <hr>
                        
                        <div class="mb-4">
                            <h6 class="text-primary">Footer Sections Visibility</h6>
                            <div class="row g-3">
                                <div class="col-md-4">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="footer_show_services" value="1" <?php echo ($settings['footer_show_services'] ?? '1') == '1' ? 'checked' : ''; ?>>
                                        <label class="form-check-label">Show Services Links</label>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="footer_show_software" value="1" <?php echo ($settings['footer_show_software'] ?? '1') == '1' ? 'checked' : ''; ?>>
                                        <label class="form-check-label">Show Software Links</label>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="footer_show_newsletter" value="1" <?php echo ($settings['footer_show_newsletter'] ?? '1') == '1' ? 'checked' : ''; ?>>
                                        <label class="form-check-label">Show Newsletter</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <hr>
                        
                        <div class="mb-4">
                            <h6 class="text-primary">Links Limits</h6>
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label class="form-label">Services Links Limit</label>
                                    <input type="number" name="footer_services_limit" class="form-control" value="<?php echo $settings['footer_services_limit'] ?? '5'; ?>" min="1" max="10">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Software Links Limit</label>
                                    <input type="number" name="footer_software_limit" class="form-control" value="<?php echo $settings['footer_software_limit'] ?? '5'; ?>" min="1" max="10">
                                </div>
                            </div>
                        </div>
                        
                        <hr>
                        
                        <div class="mb-4">
                            <h6 class="text-primary">Quick Links Section</h6>
                            <div id="quick-links-container">
                                <?php
                                $quick_links_setting = get_system_setting('footer_quick_links', '[]');
                                $quick_links = is_array($quick_links_setting) ? $quick_links_setting : json_decode($quick_links_setting, true) ?? [];
                                foreach ($quick_links as $index => $link):
                                ?>
                                <div class="row g-3 mb-2 quick-link-row">
                                    <div class="col-md-5">
                                        <input type="text" name="quick_link_title[]" class="form-control" placeholder="Link Title" value="<?php echo $link['title'] ?? ''; ?>">
                                    </div>
                                    <div class="col-md-5">
                                        <input type="url" name="quick_link_url[]" class="form-control" placeholder="Link URL" value="<?php echo $link['url'] ?? ''; ?>">
                                    </div>
                                    <div class="col-md-2">
                                        <button type="button" class="btn btn-outline-danger w-100" onclick="removeQuickLink(this)">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                            </div>
                            <button type="button" class="btn btn-outline-primary mt-2" onclick="addQuickLink()">
                                <i class="bi bi-plus-lg me-2"></i>Add Quick Link
                            </button>
                        </div>
                        
                        <hr>
                        
                        <div class="mb-4">
                            <h6 class="text-primary">Additional Links Section</h6>
                            <div id="additional-links-container">
                                <?php
                                $additional_links_setting = get_system_setting('footer_additional_links', '[]');
                                $additional_links = is_array($additional_links_setting) ? $additional_links_setting : json_decode($additional_links_setting, true) ?? [];
                                foreach ($additional_links as $index => $link):
                                ?>
                                <div class="row g-3 mb-2 additional-link-row">
                                    <div class="col-md-4">
                                        <input type="text" name="additional_link_title[]" class="form-control" placeholder="Link Title" value="<?php echo $link['title'] ?? ''; ?>">
                                    </div>
                                    <div class="col-md-4">
                                        <input type="url" name="additional_link_url[]" class="form-control" placeholder="Link URL" value="<?php echo $link['url'] ?? ''; ?>">
                                    </div>
                                    <div class="col-md-2">
                                        <select name="additional_link_section[]" class="form-select">
                                            <option value="services" <?php echo ($link['section'] ?? 'services') === 'services' ? 'selected' : ''; ?>>Services</option>
                                            <option value="software" <?php echo ($link['section'] ?? 'services') === 'software' ? 'selected' : ''; ?>>Software</option>
                                            <option value="other" <?php echo ($link['section'] ?? 'services') === 'other' ? 'selected' : ''; ?>>Other</option>
                                        </select>
                                    </div>
                                    <div class="col-md-2">
                                        <button type="button" class="btn btn-outline-danger w-100" onclick="removeAdditionalLink(this)">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                            </div>
                            <button type="button" class="btn btn-outline-primary mt-2" onclick="addAdditionalLink()">
                                <i class="bi bi-plus-lg me-2"></i>Add Additional Link
                            </button>
                        </div>
                        
                        <div class="alert alert-info">
                            <i class="bi bi-info-circle me-2"></i>
                            <strong>Note:</strong> Social media links are managed under the <a href="?tab=social">Social Media</a> tab.
                            Contact information is managed under <a href="?tab=site_info">Site Information</a>.
                        </div>
                    <?php endif; ?>
                    
                    <div class="mt-4">
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-save me-2"></i>Save Changes
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
function addQuickLink() {
    const container = document.getElementById('quick-links-container');
    const newRow = document.createElement('div');
    newRow.className = 'row g-3 mb-2 quick-link-row';
    newRow.innerHTML = `
        <div class="col-md-5">
            <input type="text" name="quick_link_title[]" class="form-control" placeholder="Link Title">
        </div>
        <div class="col-md-5">
            <input type="url" name="quick_link_url[]" class="form-control" placeholder="Link URL">
        </div>
        <div class="col-md-2">
            <button type="button" class="btn btn-outline-danger w-100" onclick="removeQuickLink(this)">
                <i class="bi bi-trash"></i>
            </button>
        </div>
    `;
    container.appendChild(newRow);
}

function removeQuickLink(button) {
    if (confirm('Remove this quick link?')) {
        button.closest('.quick-link-row').remove();
    }
}

function addAdditionalLink() {
    const container = document.getElementById('additional-links-container');
    const newRow = document.createElement('div');
    newRow.className = 'row g-3 mb-2 additional-link-row';
    newRow.innerHTML = `
        <div class="col-md-4">
            <input type="text" name="additional_link_title[]" class="form-control" placeholder="Link Title">
        </div>
        <div class="col-md-4">
            <input type="url" name="additional_link_url[]" class="form-control" placeholder="Link URL">
        </div>
        <div class="col-md-2">
            <select name="additional_link_section[]" class="form-select">
                <option value="services">Services</option>
                <option value="software">Software</option>
                <option value="other">Other</option>
            </select>
        </div>
        <div class="col-md-2">
            <button type="button" class="btn btn-outline-danger w-100" onclick="removeAdditionalLink(this)">
                <i class="bi bi-trash"></i>
            </button>
        </div>
    `;
    container.appendChild(newRow);
}

function removeAdditionalLink(button) {
    if (confirm('Remove this additional link?')) {
        button.closest('.additional-link-row').remove();
    }
}
</script>

<?php include __DIR__ . '/includes/footer.php'; ?>
