<?php
/**
 * Admin - Add Software Product
 */
require_once __DIR__ . '/../config.php';
require_admin_login();

$page_title = 'Add Software Product';
$errors = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verify_csrf_token($_POST['csrf_token'] ?? '')) {
        $errors[] = 'Invalid security token';
    } else {
        $name = sanitize($_POST['name'] ?? '');
        $slug = create_slug($name);
        $category = sanitize($_POST['category'] ?? 'other');
        $short_description = sanitize($_POST['short_description'] ?? '');
        $description = sanitize($_POST['description'] ?? '');
        $pricing_type = sanitize($_POST['pricing_type'] ?? 'contact');
        $price = floatval($_POST['price'] ?? 0);
        $button_link = sanitize($_POST['button_link'] ?? '');
        $button_text = sanitize($_POST['button_text'] ?? 'Explore');
        $status = isset($_POST['status']) ? 1 : 0;
        
        if (empty($name)) $errors[] = 'Software name is required';
        if (empty($description)) $errors[] = 'Description is required';
        
        if (empty($errors)) {
            try {
                $stmt = db()->prepare("INSERT INTO software_products 
                    (name, slug, category, short_description, description, pricing_type, price, button_link, button_text, status, created_at, updated_at)
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), NOW())");
                $stmt->execute([$name, $slug, $category, $short_description, $description, $pricing_type, $price, $button_link, $button_text, $status]);
                redirect(BASE_URL . 'admin/software.php', 'success', 'Software product added successfully');
            } catch (PDOException $e) {
                $errors[] = 'Failed to add software: ' . $e->getMessage();
            }
        }
    }
}

$csrf_token = generate_csrf_token();
include __DIR__ . '/includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="fw-bold mb-0">Add Software Product</h2>
    <a href="software.php" class="btn btn-outline-secondary"><i class="bi bi-arrow-left me-2"></i>Back</a>
</div>

<?php if (!empty($errors)): ?>
    <div class="alert alert-danger"><?php foreach ($errors as $error): ?><p class="mb-0"><?php echo $error; ?></p><?php endforeach; ?></div>
<?php endif; ?>

<div class="card border-0 shadow-sm">
    <div class="card-body p-4">
        <form method="POST">
            <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">Software Name <span class="text-danger">*</span></label>
                    <input type="text" name="name" class="form-control" required>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Category</label>
                    <select name="category" class="form-select">
                        <option value="crm">CRM</option>
                        <option value="telecalling">Telecalling</option>
                        <option value="erp">ERP</option>
                        <option value="marketing">Marketing</option>
                        <option value="website">Website Builder</option>
                        <option value="ai">AI Solutions</option>
                        <option value="other">Other</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Pricing Type</label>
                    <select name="pricing_type" class="form-select">
                        <option value="free">Free</option>
                        <option value="one_time">One Time</option>
                        <option value="subscription">Subscription</option>
                        <option value="contact">Contact for Price</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Price</label>
                    <input type="number" name="price" class="form-control" step="0.01" value="0">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Button Text</label>
                    <input type="text" name="button_text" class="form-control" value="Explore" placeholder="e.g., Explore, Try Now, Learn More">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Button Link (URL)</label>
                    <input type="text" name="button_link" class="form-control" placeholder="e.g., contact.php or https://example.com">
                    <small class="text-muted">Leave empty for default software detail page</small>
                </div>
                <div class="col-12">
                    <label class="form-label">Short Description</label>
                    <input type="text" name="short_description" class="form-control">
                </div>
                <div class="col-12">
                    <label class="form-label">Full Description <span class="text-danger">*</span></label>
                    <textarea name="description" class="form-control" rows="6" required></textarea>
                </div>
                <div class="col-12">
                    <div class="form-check">
                        <input type="checkbox" name="status" class="form-check-input" id="statusCheck" checked>
                        <label class="form-check-label" for="statusCheck">Active</label>
                    </div>
                </div>
            </div>
            <div class="mt-4">
                <button type="submit" class="btn btn-primary"><i class="bi bi-save me-2"></i>Save Software</button>
                <a href="software.php" class="btn btn-outline-secondary ms-2">Cancel</a>
            </div>
        </form>
    </div>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>
