<?php
/**
 * Admin - Software Product Categories
 */
require_once __DIR__ . '/../config.php';
require_admin_login();

$page_title = 'Software Categories';

$success = '';
$error = '';

// Get all categories
$categories = [];
try {
    $stmt = db()->query("SELECT * FROM software_categories ORDER BY sort_order, name");
    $categories = $stmt->fetchAll();
} catch (PDOException $e) {
    $error = 'Database error: ' . $e->getMessage();
}

include __DIR__ . '/includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="fw-bold mb-1">Software Categories</h2>
        <p class="text-muted mb-0">Manage software product categories</p>
    </div>
    <a href="software-category-add.php" class="btn btn-primary">
        <i class="bi bi-plus-circle me-2"></i>Add Category
    </a>
</div>

<?php if ($success): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="bi bi-check-circle-fill me-2"></i><?php echo $success; ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>
<?php if ($error): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="bi bi-exclamation-circle-fill me-2"></i><?php echo $error; ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="card border-0 shadow-sm">
    <div class="table-responsive">
        <table class="table table-hover mb-0">
            <thead class="table-light">
                <tr>
                    <th>ID</th>
                    <th>Name</th>
                    <th>Slug</th>
                    <th>Description</th>
                    <th>Sort Order</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($categories)): ?>
                    <tr>
                        <td colspan="7" class="text-center py-4 text-muted">
                            <i class="bi bi-folder2-open fs-1 d-block mb-2"></i>
                            No categories found. <a href="software-category-add.php">Create one</a>
                        </td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($categories as $cat): ?>
                    <tr>
                        <td><?php echo $cat['id']; ?></td>
                        <td>
                            <strong><?php echo $cat['name']; ?></strong>
                            <?php if ($cat['icon']): ?>
                                <br><small class="text-muted"><i class="bi <?php echo $cat['icon']; ?>"></i> <?php echo $cat['icon']; ?></small>
                            <?php endif; ?>
                        </td>
                        <td><code><?php echo $cat['slug']; ?></code></td>
                        <td><?php echo substr($cat['description'] ?? '', 0, 50); ?><?php echo strlen($cat['description'] ?? '') > 50 ? '...' : ''; ?></td>
                        <td><?php echo $cat['sort_order']; ?></td>
                        <td>
                            <span class="badge bg-<?php echo $cat['status'] ? 'success' : 'danger'; ?>">
                                <?php echo $cat['status'] ? 'Active' : 'Inactive'; ?>
                            </span>
                        </td>
                        <td>
                            <a href="software-category-edit.php?id=<?php echo $cat['id']; ?>" class="btn btn-sm btn-outline-primary">
                                <i class="bi bi-pencil"></i>
                            </a>
                            <a href="software-category-delete.php?id=<?php echo $cat['id']; ?>" class="btn btn-sm btn-outline-danger" onclick="return confirm('Are you sure?')">
                                <i class="bi bi-trash"></i>
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>
