<?php
/**
 * Admin - Delete Software Category
 */
require_once __DIR__ . '/../config.php';
require_admin_login();

$cat_id = intval($_GET['id'] ?? 0);

if (!$cat_id) {
    redirect(BASE_URL . 'admin/software-categories.php', 'error', 'Invalid category ID');
}

// Check if category exists and has no products
try {
    $stmt = db()->prepare("SELECT COUNT(*) as count FROM software_products WHERE category_id = ?");
    $stmt->execute([$cat_id]);
    $products_count = $stmt->fetch()['count'];
    
    if ($products_count > 0) {
        redirect(BASE_URL . 'admin/software-categories.php', 'error', 'Cannot delete category with existing products. Please move or delete products first.');
    }
    
    // Delete category
    $stmt = db()->prepare("DELETE FROM software_categories WHERE id = ?");
    $stmt->execute([$cat_id]);
    
    redirect(BASE_URL . 'admin/software-categories.php', 'success', 'Category deleted successfully');
} catch (PDOException $e) {
    redirect(BASE_URL . 'admin/software-categories.php', 'error', 'Failed to delete category: ' . $e->getMessage());
}
