<?php
/**
 * Admin - Delete Software Product
 */
require_once __DIR__ . '/../config.php';
require_admin_login();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    redirect(BASE_URL . 'admin/software.php', 'error', 'Invalid request');
}

if (!verify_csrf_token($_POST['csrf_token'] ?? '')) {
    redirect(BASE_URL . 'admin/software.php', 'error', 'Invalid security token');
}

$product_id = intval($_POST['product_id'] ?? 0);

if (!$product_id) {
    redirect(BASE_URL . 'admin/software.php', 'error', 'Invalid product ID');
}

try {
    // Check if product exists
    $stmt = db()->prepare("SELECT name FROM software_products WHERE id = ?");
    $stmt->execute([$product_id]);
    $product = $stmt->fetch();
    
    if (!$product) {
        redirect(BASE_URL . 'admin/software.php', 'error', 'Product not found');
    }
    
    // Delete product
    $stmt = db()->prepare("DELETE FROM software_products WHERE id = ?");
    $stmt->execute([$product_id]);
    
    // Log activity
    log_activity('software_product_deleted', "Deleted software product: {$product['name']}", $_SESSION['admin_id'], 'admin');
    
    redirect(BASE_URL . 'admin/software.php', 'success', 'Software product deleted successfully');
    
} catch (PDOException $e) {
    error_log("Delete software product error: " . $e->getMessage());
    redirect(BASE_URL . 'admin/software.php', 'error', 'Failed to delete software product');
}
