<?php
/**
 * Admin - Software Products
 */
require_once __DIR__ . '/../config.php';
require_admin_login();

$page_title = 'Software Products';

$products = [];
try {
    $stmt = db()->query("SELECT * FROM software_products ORDER BY created_at DESC");
    $products = $stmt->fetchAll();
} catch (PDOException $e) {}

include __DIR__ . '/includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="fw-bold mb-0">Software Products</h2>
    <a href="software-add.php" class="btn btn-primary"><i class="bi bi-plus-lg me-2"></i>Add Product</a>
</div>

<div class="card border-0 shadow-sm">
    <div class="table-responsive">
        <table class="table table-hover mb-0">
            <thead class="table-light">
                <tr>
                    <th>ID</th>
                    <th>Name</th>
                    <th>Category</th>
                    <th>Price</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($products as $product): ?>
                <tr>
                    <td><?php echo $product['id']; ?></td>
                    <td><?php echo $product['name']; ?></td>
                    <td><?php echo ucfirst($product['category']); ?></td>
                    <td><?php echo $product['price'] ? format_currency($product['price']) : 'Free'; ?></td>
                    <td>
                        <span class="badge bg-<?php echo $product['status'] ? 'success' : 'secondary'; ?>">
                            <?php echo $product['status'] ? 'Active' : 'Inactive'; ?>
                        </span>
                    </td>
                    <td>
                        <a href="software-edit.php?id=<?php echo $product['id']; ?>" class="btn btn-sm btn-outline-primary">
                            <i class="bi bi-pencil"></i>
                        </a>
                        <button class="btn btn-sm btn-outline-danger" onclick="deleteProduct(<?php echo $product['id']; ?>)">
                            <i class="bi bi-trash"></i>
                        </button>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php if (empty($products)): ?>
                <tr><td colspan="6" class="text-center py-4 text-muted">No products found</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<script>
function deleteProduct(productId) {
    if (confirm('Are you sure you want to delete this software product? This action cannot be undone.')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = 'software-delete.php';
        
        const csrfToken = document.createElement('input');
        csrfToken.type = 'hidden';
        csrfToken.name = 'csrf_token';
        csrfToken.value = '<?php echo generate_csrf_token(); ?>';
        
        const productIdField = document.createElement('input');
        productIdField.type = 'hidden';
        productIdField.name = 'product_id';
        productIdField.value = productId;
        
        form.appendChild(csrfToken);
        form.appendChild(productIdField);
        document.body.appendChild(form);
        form.submit();
    }
}
</script>

<?php include __DIR__ . '/includes/footer.php'; ?>
