<?php
/**
 * Admin - Delete Subscription
 */
require_once __DIR__ . '/../config.php';
require_admin_login();

$id = intval($_GET['id'] ?? 0);

if (!$id) {
    redirect(BASE_URL . 'admin/subscriptions.php', 'error', 'Invalid subscription ID');
}

try {
    // Delete related transactions first
    $stmt = db()->prepare("DELETE FROM transactions WHERE item_id = ? AND item_type = 'subscription_plan'");
    $stmt->execute([$id]);
    
    // Delete subscription
    $stmt = db()->prepare("DELETE FROM user_subscriptions WHERE id = ?");
    $stmt->execute([$id]);
    
    log_activity('subscription_deleted', "Deleted subscription ID: $id", $_SESSION['admin_id'], 'admin');
    redirect(BASE_URL . 'admin/subscriptions.php', 'success', 'Subscription deleted successfully');
} catch (PDOException $e) {
    error_log("Delete subscription error: " . $e->getMessage());
    redirect(BASE_URL . 'admin/subscriptions.php', 'error', 'Failed to delete subscription');
}
