<?php
/**
 * Admin - Subscriptions Management
 */
require_once __DIR__ . '/../config.php';
require_admin_login();

$page_title = 'Subscriptions';

$subscriptions = [];
try {
    $stmt = db()->query("SELECT us.*, u.full_name, u.email, sp.name as plan_name 
                        FROM user_subscriptions us
                        JOIN users u ON us.user_id = u.id
                        JOIN subscription_plans sp ON us.plan_id = sp.id
                        ORDER BY us.created_at DESC LIMIT 50");
    $subscriptions = $stmt->fetchAll();
} catch (PDOException $e) {}

include __DIR__ . '/includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="fw-bold mb-1">Subscriptions</h2>
        <p class="text-muted mb-0">Manage user subscriptions and billing</p>
    </div>
    <a href="subscription-add.php" class="btn btn-primary">
        <i class="bi bi-plus-circle me-2"></i>Add Manual Subscription
    </a>
</div>

<?php echo flash_message(); ?>

<div class="card border-0 shadow-sm">
    <form method="POST" action="subscription-bulk-action.php" id="bulk-form">
        <div class="card-header bg-white">
            <div class="d-flex justify-content-between align-items-center">
                <div class="btn-group">
                    <button type="submit" name="action" value="activate" class="btn btn-outline-success btn-sm" onclick="return confirm('Activate selected subscriptions?')">
                        <i class="bi bi-check-circle me-1"></i>Activate
                    </button>
                    <button type="submit" name="action" value="suspend" class="btn btn-outline-warning btn-sm" onclick="return confirm('Suspend selected subscriptions?')">
                        <i class="bi bi-pause-circle me-1"></i>Suspend
                    </button>
                    <button type="submit" name="action" value="delete" class="btn btn-outline-danger btn-sm" onclick="return confirm('Delete selected subscriptions? This action cannot be undone.')">
                        <i class="bi bi-trash me-1"></i>Delete
                    </button>
                </div>
            </div>
        </div>
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th><input type="checkbox" class="form-check-input" id="select-all"></th>
                        <th>ID</th>
                        <th>User</th>
                        <th>Plan</th>
                        <th>Type</th>
                        <th>Amount</th>
                        <th>Status</th>
                        <th>Start Date</th>
                        <th>End Date</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($subscriptions as $sub): ?>
                    <tr>
                        <td><input type="checkbox" class="form-check-input row-checkbox" name="ids[]" value="<?php echo $sub['id']; ?>"></td>
                        <td><?php echo $sub['id']; ?></td>
                        <td>
                            <strong><?php echo $sub['full_name']; ?></strong>
                            <br><small class="text-muted"><?php echo $sub['email']; ?></small>
                        </td>
                        <td><?php echo $sub['plan_name']; ?></td>
                        <td><?php echo ucfirst($sub['subscription_type']); ?></td>
                        <td><?php echo format_currency($sub['amount']); ?></td>
                        <td>
                            <span class="badge bg-<?php 
                                echo $sub['status'] === 'active' ? 'success' : 
                                    ($sub['status'] === 'expired' ? 'danger' : 'warning'); 
                            ?>"><?php echo ucfirst($sub['status']); ?></span>
                        </td>
                        <td><?php echo format_date($sub['start_date']); ?></td>
                        <td><?php echo format_date($sub['end_date']); ?></td>
                        <td>
                            <a href="subscription-edit.php?id=<?php echo $sub['id']; ?>" class="btn btn-sm btn-outline-primary">
                                <i class="bi bi-pencil"></i>
                            </a>
                            <a href="subscription-delete.php?id=<?php echo $sub['id']; ?>" class="btn btn-sm btn-outline-danger" onclick="return confirm('Delete this subscription?')">
                                <i class="bi bi-trash"></i>
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                    <?php if (empty($subscriptions)): ?>
                    <tr><td colspan="10" class="text-center py-4 text-muted">No subscriptions found</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </form>
</div>

<script>
document.getElementById('select-all').addEventListener('change', function() {
    document.querySelectorAll('.row-checkbox').forEach(cb => cb.checked = this.checked);
});
</script>

<?php include __DIR__ . '/includes/footer.php'; ?>
