<?php
/**
 * Admin - Add Team Member
 */
require_once __DIR__ . '/../config.php';
require_admin_login();

$page_title = 'Add Team Member';
$errors = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verify_csrf_token($_POST['csrf_token'] ?? '')) {
        $errors[] = 'Invalid security token';
    } else {
        $name = sanitize($_POST['name'] ?? '');
        $designation = sanitize($_POST['designation'] ?? '');
        $bio = sanitize($_POST['bio'] ?? '');
        $sort_order = intval($_POST['sort_order'] ?? 0);
        $status = isset($_POST['status']) ? 1 : 0;
        
        if (empty($name)) $errors[] = 'Name is required';
        if (empty($designation)) $errors[] = 'Designation is required';
        
        // Handle image upload
        $image = '';
        if (!empty($_FILES['image']['name'])) {
            $upload = upload_file($_FILES['image'], 'team', ALLOWED_IMAGE_TYPES);
            if ($upload['success']) {
                $image = $upload['path'];
            } else {
                $errors[] = $upload['message'];
            }
        }
        
        if (empty($errors)) {
            try {
                $stmt = db()->prepare("INSERT INTO team_members 
                    (name, designation, bio, image, sort_order, status) 
                    VALUES (?, ?, ?, ?, ?, ?)");
                $stmt->execute([$name, $designation, $bio, $image, $sort_order, $status]);
                redirect(BASE_URL . 'admin/team-members.php', 'success', 'Team member added successfully');
            } catch (PDOException $e) {
                $errors[] = 'Failed to add member: ' . $e->getMessage();
            }
        }
    }
}

$csrf_token = generate_csrf_token();
include __DIR__ . '/includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="fw-bold mb-0">Add Team Member</h2>
    <a href="team-members.php" class="btn btn-outline-secondary"><i class="bi bi-arrow-left me-2"></i>Back</a>
</div>

<?php if (!empty($errors)): ?>
    <div class="alert alert-danger"><?php foreach ($errors as $error): ?><p class="mb-0"><?php echo $error; ?></p><?php endforeach; ?></div>
<?php endif; ?>

<div class="card border-0 shadow-sm">
    <div class="card-body p-4">
        <form method="POST" enctype="multipart/form-data">
            <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">Name <span class="text-danger">*</span></label>
                    <input type="text" name="name" class="form-control" required>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Designation <span class="text-danger">*</span></label>
                    <input type="text" name="designation" class="form-control" required placeholder="e.g., CEO, Developer">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Photo</label>
                    <input type="file" name="image" class="form-control" accept="image/*">
                    <small class="text-muted">Recommended: 400x400px, Max 2MB</small>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Sort Order</label>
                    <input type="number" name="sort_order" class="form-control" value="0">
                </div>
                <div class="col-md-3">
                    <div class="form-check mt-4">
                        <input type="checkbox" name="status" class="form-check-input" id="statusCheck" checked>
                        <label class="form-check-label" for="statusCheck">Active</label>
                    </div>
                </div>
                <div class="col-12">
                    <label class="form-label">Bio</label>
                    <textarea name="bio" class="form-control" rows="4" placeholder="Brief biography..."></textarea>
                </div>
            </div>
            <div class="mt-4">
                <button type="submit" class="btn btn-primary"><i class="bi bi-save me-2"></i>Save Member</button>
                <a href="team-members.php" class="btn btn-outline-secondary ms-2">Cancel</a>
            </div>
        </form>
    </div>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>
