<?php
/**
 * Admin - Add Testimonial
 */
require_once __DIR__ . '/../config.php';
require_admin_login();

$page_title = 'Add Testimonial';
$errors = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verify_csrf_token($_POST['csrf_token'] ?? '')) {
        $errors[] = 'Invalid security token';
    } else {
        $client_name = sanitize($_POST['client_name'] ?? '');
        $designation = sanitize($_POST['designation'] ?? '');
        $company = sanitize($_POST['company'] ?? '');
        $content = sanitize($_POST['content'] ?? '');
        $rating = intval($_POST['rating'] ?? 5);
        $sort_order = intval($_POST['sort_order'] ?? 0);
        $status = isset($_POST['status']) ? 1 : 0;
        
        if (empty($client_name)) $errors[] = 'Client name is required';
        if (empty($content)) $errors[] = 'Testimonial content is required';
        
        if (empty($errors)) {
            try {
                $stmt = db()->prepare("INSERT INTO testimonials 
                    (client_name, designation, company, content, rating, sort_order, status, created_at, updated_at)
                    VALUES (?, ?, ?, ?, ?, ?, ?, NOW(), NOW())");
                $stmt->execute([$client_name, $designation, $company, $content, $rating, $sort_order, $status]);
                redirect(BASE_URL . 'admin/testimonials.php', 'success', 'Testimonial added successfully');
            } catch (PDOException $e) {
                $errors[] = 'Failed to add testimonial: ' . $e->getMessage();
            }
        }
    }
}

$csrf_token = generate_csrf_token();
include __DIR__ . '/includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="fw-bold mb-0">Add Testimonial</h2>
    <a href="testimonials.php" class="btn btn-outline-secondary"><i class="bi bi-arrow-left me-2"></i>Back</a>
</div>

<?php if (!empty($errors)): ?>
    <div class="alert alert-danger"><?php foreach ($errors as $error): ?><p class="mb-0"><?php echo $error; ?></p><?php endforeach; ?></div>
<?php endif; ?>

<div class="card border-0 shadow-sm">
    <div class="card-body p-4">
        <form method="POST">
            <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">Client Name <span class="text-danger">*</span></label>
                    <input type="text" name="client_name" class="form-control" required>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Designation</label>
                    <input type="text" name="designation" class="form-control" placeholder="e.g., CEO, Manager">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Company</label>
                    <input type="text" name="company" class="form-control">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Rating (1-5)</label>
                    <select name="rating" class="form-select">
                        <option value="5">5 Stars</option>
                        <option value="4">4 Stars</option>
                        <option value="3">3 Stars</option>
                        <option value="2">2 Stars</option>
                        <option value="1">1 Star</option>
                    </select>
                </div>
                <div class="col-12">
                    <label class="form-label">Testimonial <span class="text-danger">*</span></label>
                    <textarea name="content" class="form-control" rows="4" required></textarea>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Sort Order</label>
                    <input type="number" name="sort_order" class="form-control" value="0">
                </div>
                <div class="col-12">
                    <div class="form-check">
                        <input type="checkbox" name="status" class="form-check-input" id="statusCheck" checked>
                        <label class="form-check-label" for="statusCheck">Active</label>
                    </div>
                </div>
            </div>
            <div class="mt-4">
                <button type="submit" class="btn btn-primary"><i class="bi bi-save me-2"></i>Save Testimonial</button>
                <a href="testimonials.php" class="btn btn-outline-secondary ms-2">Cancel</a>
            </div>
        </form>
    </div>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>
