<?php
/**
 * Admin - Delete Testimonial
 */
require_once __DIR__ . '/../config.php';
require_admin_login();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    redirect(BASE_URL . 'admin/testimonials.php', 'error', 'Invalid request');
}

if (!verify_csrf_token($_POST['csrf_token'] ?? '')) {
    redirect(BASE_URL . 'admin/testimonials.php', 'error', 'Invalid security token');
}

$testimonial_id = intval($_POST['testimonial_id'] ?? 0);

if (!$testimonial_id) {
    redirect(BASE_URL . 'admin/testimonials.php', 'error', 'Invalid testimonial ID');
}

try {
    // Check if testimonial exists
    $stmt = db()->prepare("SELECT name FROM testimonials WHERE id = ?");
    $stmt->execute([$testimonial_id]);
    $testimonial = $stmt->fetch();
    
    if (!$testimonial) {
        redirect(BASE_URL . 'admin/testimonials.php', 'error', 'Testimonial not found');
    }
    
    // Delete testimonial
    $stmt = db()->prepare("DELETE FROM testimonials WHERE id = ?");
    $stmt->execute([$testimonial_id]);
    
    // Log activity
    log_activity('testimonial_deleted', "Deleted testimonial: {$testimonial['name']}", $_SESSION['admin_id'], 'admin');
    
    redirect(BASE_URL . 'admin/testimonials.php', 'success', 'Testimonial deleted successfully');
    
} catch (PDOException $e) {
    error_log("Delete testimonial error: " . $e->getMessage());
    redirect(BASE_URL . 'admin/testimonials.php', 'error', 'Failed to delete testimonial');
}
