<?php
/**
 * Admin - Testimonials
 */
require_once __DIR__ . '/../config.php';
require_admin_login();

$page_title = 'Testimonials';

$testimonials = [];
try {
    $stmt = db()->query("SELECT * FROM testimonials ORDER BY created_at DESC");
    $testimonials = $stmt->fetchAll();
} catch (PDOException $e) {}

include __DIR__ . '/includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="fw-bold mb-0">Testimonials</h2>
    <a href="testimonial-add.php" class="btn btn-primary"><i class="bi bi-plus-lg me-2"></i>Add Testimonial</a>
</div>

<div class="row g-4">
    <?php foreach ($testimonials as $t): ?>
    <div class="col-md-6 col-lg-4">
        <div class="card h-100 border-0 shadow-sm">
            <div class="card-body">
                <div class="d-flex align-items-center mb-3">
                    <div class="bg-primary bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px;">
                        <i class="bi bi-person text-primary fs-4"></i>
                    </div>
                    <div>
                        <h6 class="mb-0 fw-bold"><?php echo $t['name']; ?></h6>
                        <small class="text-muted"><?php echo $t['designation']; ?></small>
                    </div>
                </div>
                <p class="text-muted small">"<?php echo substr($t['content'], 0, 120); ?>..."</p>
                <div class="text-warning">
                    <?php for ($i = 0; $i < ($t['rating'] ?? 5); $i++): ?>
                        <i class="bi bi-star-fill"></i>
                    <?php endfor; ?>
                </div>
            </div>
            <div class="card-footer bg-white border-top-0 d-flex justify-content-between">
                <span class="badge bg-<?php echo $t['status'] ? 'success' : 'secondary'; ?>">
                    <?php echo $t['status'] ? 'Active' : 'Inactive'; ?>
                </span>
                <div>
                    <a href="testimonial-edit.php?id=<?php echo $t['id']; ?>" class="btn btn-sm btn-outline-primary">
                        <i class="bi bi-pencil"></i>
                    </a>
                    <button class="btn btn-sm btn-outline-danger" onclick="deleteTestimonial(<?php echo $t['id']; ?>)">
                        <i class="bi bi-trash"></i>
                    </button>
                </div>
            </div>
        </div>
    </div>
    <?php endforeach; ?>
    <?php if (empty($testimonials)): ?>
    <div class="col-12 text-center py-5 text-muted">No testimonials found</div>
    <?php endif; ?>
</div>

<script>
function deleteTestimonial(testimonialId) {
    if (confirm('Are you sure you want to delete this testimonial? This action cannot be undone.')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = 'testimonial-delete.php';
        
        const csrfToken = document.createElement('input');
        csrfToken.type = 'hidden';
        csrfToken.name = 'csrf_token';
        csrfToken.value = '<?php echo generate_csrf_token(); ?>';
        
        const testimonialIdField = document.createElement('input');
        testimonialIdField.type = 'hidden';
        testimonialIdField.name = 'testimonial_id';
        testimonialIdField.value = testimonialId;
        
        form.appendChild(csrfToken);
        form.appendChild(testimonialIdField);
        document.body.appendChild(form);
        form.submit();
    }
}
</script>

<?php include __DIR__ . '/includes/footer.php'; ?>
