<?php
/**
 * Admin - Support Tickets
 */
require_once __DIR__ . '/../config.php';
require_admin_login();

$page_title = 'Support Tickets';

$tickets = [];
try {
    // Check if support_tickets table exists
    $table_check = db()->query("SHOW TABLES LIKE 'support_tickets'");
    if ($table_check->rowCount() > 0) {
        $stmt = db()->query("SELECT t.*, u.full_name, u.email 
                            FROM support_tickets t
                            JOIN users u ON t.user_id = u.id
                            ORDER BY t.created_at DESC LIMIT 50");
        $tickets = $stmt->fetchAll();
    } else {
        error_log("Support tickets table does not exist");
    }
} catch (PDOException $e) {
    error_log("Admin tickets query error: " . $e->getMessage());
}

include __DIR__ . '/includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="fw-bold mb-0">Support Tickets</h2>
</div>

<div class="card border-0 shadow-sm">
    <div class="table-responsive">
        <table class="table table-hover mb-0">
            <thead class="table-light">
                <tr>
                    <th>Ticket #</th>
                    <th>User</th>
                    <th>Subject</th>
                    <th>Priority</th>
                    <th>Status</th>
                    <th>Created</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($tickets as $ticket): ?>
                <tr>
                    <td><?php echo $ticket['ticket_number']; ?></td>
                    <td><?php echo $ticket['full_name']; ?></td>
                    <td><?php echo substr($ticket['subject'], 0, 40); ?>...</td>
                    <td>
                        <span class="badge bg-<?php 
                            echo $ticket['priority'] === 'urgent' ? 'danger' : 
                                ($ticket['priority'] === 'high' ? 'warning' : 
                                ($ticket['priority'] === 'medium' ? 'info' : 'secondary')); 
                        ?>"><?php echo ucfirst($ticket['priority']); ?></span>
                    </td>
                    <td>
                        <span class="badge bg-<?php 
                            echo $ticket['status'] === 'open' ? 'danger' : 
                                ($ticket['status'] === 'in_progress' ? 'warning' : 'success'); 
                        ?>"><?php echo ucfirst(str_replace('_', ' ', $ticket['status'])); ?></span>
                    </td>
                    <td><?php echo format_date($ticket['created_at']); ?></td>
                    <td>
                        <a href="ticket-view.php?id=<?php echo $ticket['id']; ?>" class="btn btn-sm btn-primary">Reply</a>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php if (empty($tickets)): ?>
                <tr><td colspan="7" class="text-center py-4 text-muted">No tickets found</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>
