<?php
/**
 * Admin - Transactions
 */
require_once __DIR__ . '/../config.php';
require_admin_login();

$page_title = 'Transactions';

$transactions = [];
try {
    $stmt = db()->query("SELECT t.*, u.full_name, u.email 
                        FROM transactions t
                        JOIN users u ON t.user_id = u.id
                        ORDER BY t.created_at DESC LIMIT 50");
    $transactions = $stmt->fetchAll();
} catch (PDOException $e) {}

include __DIR__ . '/includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="fw-bold mb-0">Transactions</h2>
</div>

<div class="card border-0 shadow-sm">
    <div class="table-responsive">
        <table class="table table-hover mb-0">
            <thead class="table-light">
                <tr>
                    <th>Transaction #</th>
                    <th>User</th>
                    <th>Type</th>
                    <th>Amount</th>
                    <th>Gateway</th>
                    <th>Status</th>
                    <th>Date</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($transactions as $tx): ?>
                <tr>
                    <td><?php echo $tx['transaction_number']; ?></td>
                    <td><?php echo $tx['full_name']; ?></td>
                    <td><?php echo ucfirst(str_replace('_', ' ', $tx['transaction_type'])); ?></td>
                    <td><?php echo format_currency($tx['total_amount']); ?></td>
                    <td><?php echo ucfirst($tx['payment_gateway'] ?? 'N/A'); ?></td>
                    <td>
                        <span class="badge bg-<?php 
                            echo $tx['status'] === 'success' ? 'success' : 
                                ($tx['status'] === 'pending' ? 'warning' : 'danger'); 
                        ?>"><?php echo ucfirst($tx['status']); ?></span>
                    </td>
                    <td><?php echo format_date($tx['created_at']); ?></td>
                </tr>
                <?php endforeach; ?>
                <?php if (empty($transactions)): ?>
                <tr><td colspan="7" class="text-center py-4 text-muted">No transactions found</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>
