<?php
/**
 * Admin - View User Details
 */
require_once __DIR__ . '/../config.php';
require_admin_login();

$page_title = 'User Details';
$user_id = intval($_GET['id'] ?? 0);

$user = null;
$subscriptions = [];
$tickets = [];
$transactions = [];

try {
    $stmt = db()->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->execute([$user_id]);
    $user = $stmt->fetch();
    
    if ($user) {
        $stmt = db()->prepare("SELECT us.*, sp.name as plan_name FROM user_subscriptions us JOIN subscription_plans sp ON us.plan_id = sp.id WHERE us.user_id = ? ORDER BY us.created_at DESC");
        $stmt->execute([$user_id]);
        $subscriptions = $stmt->fetchAll();
        
        $stmt = db()->prepare("SELECT * FROM support_tickets WHERE user_id = ? ORDER BY created_at DESC LIMIT 5");
        $stmt->execute([$user_id]);
        $tickets = $stmt->fetchAll();
        
        $stmt = db()->prepare("SELECT * FROM transactions WHERE user_id = ? ORDER BY created_at DESC LIMIT 5");
        $stmt->execute([$user_id]);
        $transactions = $stmt->fetchAll();
    }
} catch (PDOException $e) {}

if (!$user) {
    redirect(BASE_URL . 'admin/users.php', 'error', 'User not found');
}

include __DIR__ . '/includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="fw-bold mb-0">User Details</h2>
    <a href="users.php" class="btn btn-outline-secondary">
        <i class="bi bi-arrow-left me-2"></i>Back to Users
    </a>
</div>

<div class="row">
    <div class="col-lg-4">
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-body text-center">
                <div class="bg-primary bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center mx-auto mb-3" style="width: 80px; height: 80px;">
                    <i class="bi bi-person text-primary" style="font-size: 2.5rem;"></i>
                </div>
                <h5 class="fw-bold"><?php echo $user['full_name']; ?></h5>
                <p class="text-muted mb-2"><?php echo $user['email']; ?></p>
                <p class="text-muted mb-3"><?php echo $user['phone'] ?? 'No phone'; ?></p>
                <span class="badge bg-<?php echo $user['status'] === 'active' ? 'success' : 'secondary'; ?>">
                    <?php echo ucfirst($user['status']); ?>
                </span>
            </div>
        </div>
        
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-white">
                <h6 class="mb-0">Account Info</h6>
            </div>
            <div class="card-body">
                <p class="mb-2"><strong>Company:</strong> <?php echo $user['company_name'] ?? '-'; ?></p>
                <p class="mb-2"><strong>Joined:</strong> <?php echo format_date($user['created_at']); ?></p>
                <p class="mb-0"><strong>Last Login:</strong> <?php echo $user['last_login'] ? format_date($user['last_login']) : 'Never'; ?></p>
            </div>
        </div>
    </div>
    
    <div class="col-lg-8">
        <!-- Subscriptions -->
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-header bg-white py-3">
                <h6 class="mb-0">Subscriptions (<?php echo count($subscriptions); ?>)</h6>
            </div>
            <div class="card-body p-0">
                <?php if (empty($subscriptions)): ?>
                <p class="text-muted p-3 mb-0">No subscriptions</p>
                <?php else: ?>
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Plan</th>
                                <th>Status</th>
                                <th>Amount</th>
                                <th>End Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach (array_slice($subscriptions, 0, 3) as $sub): ?>
                            <tr>
                                <td><?php echo $sub['plan_name']; ?></td>
                                <td>
                                    <span class="badge bg-<?php echo $sub['status'] === 'active' ? 'success' : 'danger'; ?>">
                                        <?php echo ucfirst($sub['status']); ?>
                                    </span>
                                </td>
                                <td><?php echo format_currency($sub['amount']); ?></td>
                                <td><?php echo format_date($sub['end_date']); ?></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Recent Tickets -->
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-header bg-white py-3">
                <h6 class="mb-0">Recent Tickets (<?php echo count($tickets); ?>)</h6>
            </div>
            <div class="card-body p-0">
                <?php if (empty($tickets)): ?>
                <p class="text-muted p-3 mb-0">No tickets</p>
                <?php else: ?>
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Ticket #</th>
                                <th>Subject</th>
                                <th>Status</th>
                                <th>Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach (array_slice($tickets, 0, 3) as $ticket): ?>
                            <tr>
                                <td><?php echo $ticket['ticket_number']; ?></td>
                                <td><?php echo substr($ticket['subject'], 0, 30); ?>...</td>
                                <td>
                                    <span class="badge bg-<?php 
                                        echo $ticket['status'] === 'open' ? 'danger' : 
                                            ($ticket['status'] === 'in_progress' ? 'warning' : 'success'); 
                                    ?>"><?php echo ucfirst(str_replace('_', ' ', $ticket['status'])); ?></span>
                                </td>
                                <td><?php echo format_date($ticket['created_at']); ?></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Recent Transactions -->
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-white py-3">
                <h6 class="mb-0">Recent Transactions (<?php echo count($transactions); ?>)</h6>
            </div>
            <div class="card-body p-0">
                <?php if (empty($transactions)): ?>
                <p class="text-muted p-3 mb-0">No transactions</p>
                <?php else: ?>
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Transaction #</th>
                                <th>Amount</th>
                                <th>Status</th>
                                <th>Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach (array_slice($transactions, 0, 3) as $tx): ?>
                            <tr>
                                <td><?php echo $tx['transaction_number']; ?></td>
                                <td><?php echo format_currency($tx['total_amount']); ?></td>
                                <td>
                                    <span class="badge bg-<?php 
                                        echo $tx['status'] === 'success' ? 'success' : 
                                            ($tx['status'] === 'pending' ? 'warning' : 'danger'); 
                                    ?>"><?php echo ucfirst($tx['status']); ?></span>
                                </td>
                                <td><?php echo format_date($tx['created_at']); ?></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>
