<?php
/**
 * Footer Template
 * Included at the bottom of all pages
 */

// Get site settings for footer
$site_email = get_system_setting('contact_email', 'support@hostxolo.com');
$site_phone = get_system_setting('contact_phone', '+91-6388758325');
$site_address = get_system_setting('contact_address', 'India');
$footer_about_text = get_system_setting('footer_about_text', 'Your trusted partner for business growth. We provide comprehensive digital solutions to help your business thrive in the modern marketplace.');
$footer_copyright = get_system_setting('footer_copyright', 'All rights reserved.');
$footer_show_services = get_system_setting('footer_show_services', true);
$footer_show_software = get_system_setting('footer_show_software', true);
$footer_show_newsletter = get_system_setting('footer_show_newsletter', true);
$footer_services_limit = get_system_setting('footer_services_limit', 5);
$footer_software_limit = get_system_setting('footer_software_limit', 5);
$social_facebook = get_system_setting('social_facebook', '');
$social_twitter = get_system_setting('social_twitter', '');
$social_instagram = get_system_setting('social_instagram', '');
$social_linkedin = get_system_setting('social_linkedin', '');
$social_youtube = get_system_setting('social_youtube', '');
$social_whatsapp = get_system_setting('social_whatsapp', '+91-6388758325');
$footer_quick_links_setting = get_system_setting('footer_quick_links', '[]');
$footer_quick_links = is_array($footer_quick_links_setting) ? $footer_quick_links_setting : json_decode($footer_quick_links_setting, true) ?? [];
$footer_additional_links_setting = get_system_setting('footer_additional_links', '[]');
$footer_additional_links = is_array($footer_additional_links_setting) ? $footer_additional_links_setting : json_decode($footer_additional_links_setting, true) ?? [];

// Get services for footer
$footer_services = [];
if ($footer_show_services) {
    try {
        $stmt = db()->query("SELECT name, slug FROM services WHERE status = 1 ORDER BY sort_order LIMIT " . (int)$footer_services_limit);
        $footer_services = $stmt->fetchAll();
    } catch (PDOException $e) {
        // Silently continue
    }
}

// Get software for footer
$footer_software = [];
if ($footer_show_software) {
    try {
        $stmt = db()->query("SELECT name, slug FROM software_products WHERE status = 1 ORDER BY sort_order LIMIT " . (int)$footer_software_limit);
        $footer_software = $stmt->fetchAll();
    } catch (PDOException $e) {
        // Silently continue
    }
}
?>

    <!-- Footer -->
    <footer class="bg-dark text-white pt-5 pb-3">
        <div class="container">
            <div class="row g-4">
                <!-- About Column -->
                <div class="col-lg-3 col-md-6">
                    <h4 class="fw-bold mb-3"><span class="text-primary">HOST</span>XOLO</h4>
                    <p class="text-light"><?php echo $footer_about_text; ?></p>
                    <div class="d-flex gap-3 mt-3">
                        <?php if (!empty($social_facebook)): ?>
                            <a href="<?php echo $social_facebook; ?>" class="text-white hover-primary" target="_blank"><i class="bi bi-facebook fs-5"></i></a>
                        <?php endif; ?>
                        <?php if (!empty($social_twitter)): ?>
                            <a href="<?php echo $social_twitter; ?>" class="text-white hover-primary" target="_blank"><i class="bi bi-twitter-x fs-5"></i></a>
                        <?php endif; ?>
                        <?php if (!empty($social_instagram)): ?>
                            <a href="<?php echo $social_instagram; ?>" class="text-white hover-primary" target="_blank"><i class="bi bi-instagram fs-5"></i></a>
                        <?php endif; ?>
                        <?php if (!empty($social_linkedin)): ?>
                            <a href="<?php echo $social_linkedin; ?>" class="text-white hover-primary" target="_blank"><i class="bi bi-linkedin fs-5"></i></a>
                        <?php endif; ?>
                        <?php if (!empty($social_youtube)): ?>
                            <a href="<?php echo $social_youtube; ?>" class="text-white hover-primary" target="_blank"><i class="bi bi-youtube fs-5"></i></a>
                        <?php endif; ?>
                        <?php if (!empty($social_whatsapp)): ?>
                            <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $social_whatsapp); ?>" class="text-white hover-primary" target="_blank"><i class="bi bi-whatsapp fs-5"></i></a>
                        <?php endif; ?>
                    </div>
                </div>
                
                <!-- Services Column -->
                <div class="col-lg-2 col-md-6">
                    <h5 class="fw-bold mb-3">Services</h5>
                    <ul class="list-unstyled footer-links">
                        <?php foreach ($footer_services as $service): ?>
                            <li><a href="<?php echo BASE_URL; ?>service.php?slug=<?php echo $service['slug']; ?>" class="text-light text-decoration-none"><?php echo $service['name']; ?></a></li>
                        <?php endforeach; ?>
                        <li><a href="<?php echo BASE_URL; ?>services.php" class="text-light text-decoration-none">View All Services</a></li>
                        
                        <?php if (!empty($footer_additional_links)): ?>
                            <?php $service_links = array_filter($footer_additional_links, function($link) { return $link['section'] === 'services'; }); ?>
                            <?php foreach ($service_links as $link): ?>
                                <li><a href="<?php echo $link['url']; ?>" class="text-light text-decoration-none"><?php echo $link['title']; ?></a></li>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </ul>
                </div>
                
                <!-- Software Column -->
                <div class="col-lg-2 col-md-6">
                    <h5 class="fw-bold mb-3">Software</h5>
                    <ul class="list-unstyled footer-links">
                        <?php foreach ($footer_software as $software): ?>
                            <li><a href="<?php echo BASE_URL; ?>software-detail.php?slug=<?php echo $software['slug']; ?>" class="text-light text-decoration-none"><?php echo $software['name']; ?></a></li>
                        <?php endforeach; ?>
                        <li><a href="<?php echo BASE_URL; ?>software.php" class="text-light text-decoration-none">View All Software</a></li>
                        
                        <?php if (!empty($footer_additional_links)): ?>
                            <?php $software_links = array_filter($footer_additional_links, function($link) { return $link['section'] === 'software'; }); ?>
                            <?php foreach ($software_links as $link): ?>
                                <li><a href="<?php echo $link['url']; ?>" class="text-light text-decoration-none"><?php echo $link['title']; ?></a></li>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </ul>
                </div>
                
                <!-- Quick Links Column -->
                <div class="col-lg-2 col-md-6">
                    <h5 class="fw-bold mb-3">Quick Links</h5>
                    <ul class="list-unstyled footer-links">
                        <?php if (!empty($footer_quick_links)): ?>
                            <?php foreach ($footer_quick_links as $link): ?>
                                <li><a href="<?php echo $link['url']; ?>" class="text-light text-decoration-none"><?php echo $link['title']; ?></a></li>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <li><a href="<?php echo BASE_URL; ?>about.php" class="text-light text-decoration-none">About Us</a></li>
                            <li><a href="<?php echo BASE_URL; ?>plans.php" class="text-light text-decoration-none">Business Growth Plan</a></li>
                            <li><a href="<?php echo BASE_URL; ?>blog.php" class="text-light text-decoration-none">Blog</a></li>
                            <li><a href="<?php echo BASE_URL; ?>contact.php" class="text-light text-decoration-none">Contact Us</a></li>
                            <li><a href="<?php echo BASE_URL; ?>support.php" class="text-light text-decoration-none">Support</a></li>
                        <?php endif; ?>
                        
                        <?php if (!empty($footer_additional_links)): ?>
                            <?php $other_links = array_filter($footer_additional_links, function($link) { return $link['section'] === 'other'; }); ?>
                            <?php foreach ($other_links as $link): ?>
                                <li><a href="<?php echo $link['url']; ?>" class="text-light text-decoration-none"><?php echo $link['title']; ?></a></li>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </ul>
                </div>
                
                <!-- Contact Column -->
                <div class="col-lg-3 col-md-6">
                    <h5 class="fw-bold mb-3">Contact Us</h5>
                    <ul class="list-unstyled text-light">
                        <li class="mb-2"><i class="bi bi-envelope me-2 text-primary"></i> <?php echo $site_email; ?></li>
                        <li class="mb-2"><i class="bi bi-phone me-2 text-primary"></i> <?php echo $site_phone; ?></li>
                        <li class="mb-2"><i class="bi bi-whatsapp me-2 text-primary"></i> <?php echo $social_whatsapp; ?></li>
                        <li class="mb-2"><i class="bi bi-geo-alt me-2 text-primary"></i> <?php echo $site_address; ?></li>
                    </ul>
                    
                    <!-- Newsletter -->
                    <?php if ($footer_show_newsletter): ?>
                    <div class="mt-3">
                        <h6 class="fw-bold">Newsletter</h6>
                        <form action="<?php echo BASE_URL; ?>newsletter-subscribe.php" method="POST" class="mt-2">
                            <div class="input-group">
                                <input type="email" name="email" class="form-control form-control-sm" placeholder="Your email" required>
                                <button class="btn btn-primary btn-sm" type="submit"><i class="bi bi-send"></i></button>
                            </div>
                        </form>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            
            <hr class="my-4 border-secondary">
            
            <div class="row">
                <div class="col-md-6 text-center text-md-start">
                    <p class="mb-0 text-light">&copy; <?php echo date('Y'); ?> <?php echo $site_name; ?>. <?php echo $footer_copyright; ?></p>
                </div>
                <div class="col-md-6 text-center text-md-end">
                    <ul class="list-inline mb-0">
                        <li class="list-inline-item"><a href="<?php echo BASE_URL; ?>privacy-policy.php" class="text-light text-decoration-none">Privacy Policy</a></li>
                        <li class="list-inline-item">|</li>
                        <li class="list-inline-item"><a href="<?php echo BASE_URL; ?>terms-conditions.php" class="text-light text-decoration-none">Terms & Conditions</a></li>
                        <li class="list-inline-item">|</li>
                        <li class="list-inline-item"><a href="<?php echo BASE_URL; ?>refund-cancellation.php" class="text-light text-decoration-none">Refund Policy</a></li>
                        <li class="list-inline-item">|</li>
                        <li class="list-inline-item"><a href="<?php echo BASE_URL; ?>disclaimer.php" class="text-light text-decoration-none">Disclaimer</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </footer>
    
    <!-- Back to Top Button -->
    <a href="#" class="btn btn-primary btn-lg back-to-top" id="backToTop">
        <i class="bi bi-arrow-up"></i>
    </a>
    
    <!-- Bootstrap 5 JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Custom JS -->
    <script src="<?php echo ASSETS_URL; ?>js/main.js"></script>
    
    <?php if (isset($extra_js)): ?>
        <?php echo $extra_js; ?>
    <?php endif; ?>
    
    <script>
        // Mobile responsive enhancements
        document.addEventListener('DOMContentLoaded', function() {
            // Back to top button functionality
            const backToTopBtn = document.getElementById('backToTop');
            
            if (backToTopBtn) {
                window.addEventListener('scroll', function() {
                    if (window.pageYOffset > 300) {
                        backToTopBtn.style.display = 'block';
                    } else {
                        backToTopBtn.style.display = 'none';
                    }
                });
                
                backToTopBtn.addEventListener('click', function(e) {
                    e.preventDefault();
                    window.scrollTo({ top: 0, behavior: 'smooth' });
                });
            }
            
            // Mobile navigation improvements
            const navbarToggler = document.querySelector('.navbar-toggler');
            const navbarCollapse = document.querySelector('.navbar-collapse');
            
            if (navbarToggler && navbarCollapse) {
                // Close mobile menu when clicking outside
                document.addEventListener('click', function(e) {
                    if (!navbarToggler.contains(e.target) && !navbarCollapse.contains(e.target)) {
                        navbarCollapse.classList.remove('show');
                    }
                });
                
                // Close mobile menu when clicking on links
                const navLinks = navbarCollapse.querySelectorAll('.nav-link');
                navLinks.forEach(link => {
                    link.addEventListener('click', function() {
                        navbarCollapse.classList.remove('show');
                    });
                });
            }
            
            // Mobile touch optimizations
            if ('ontouchstart' in window) {
                document.body.classList.add('touch-device');
                
                // Add active states for touch devices
                const buttons = document.querySelectorAll('.btn, .nav-link, .card-link');
                buttons.forEach(button => {
                    button.addEventListener('touchstart', function() {
                        this.classList.add('touch-active');
                    });
                    button.addEventListener('touchend', function() {
                        setTimeout(() => {
                            this.classList.remove('touch-active');
                        }, 150);
                    });
                });
            }
            
            // Responsive image handling
            const images = document.querySelectorAll('img');
            images.forEach(img => {
                if (!img.hasAttribute('loading')) {
                    img.setAttribute('loading', 'lazy');
                }
            });
            
            // Mobile form improvements
            const forms = document.querySelectorAll('form');
            forms.forEach(form => {
                const inputs = form.querySelectorAll('input, textarea, select');
                inputs.forEach(input => {
                    // Prevent zoom on focus for iOS
                    input.addEventListener('focus', function() {
                        if (window.innerWidth <= 768) {
                            document.querySelector('meta[name="viewport"]').setAttribute('content', 'width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no');
                        }
                    });
                    
                    input.addEventListener('blur', function() {
                        document.querySelector('meta[name="viewport"]').setAttribute('content', 'width=device-width, initial-scale=1.0');
                    });
                });
            });
        });
    </script>
</body>
</html>
