<?php
/**
 * Header Template
 * Included at the top of all pages
 */
require_once __DIR__ . '/../config.php';

// Get current page
$current_page = basename($_SERVER['PHP_SELF'], '.php');

// Get site settings
$site_name = get_setting('site_name', 'Hostxolo');
$site_logo = get_setting('site_logo', 'assets/images/logo.png');

// Get SEO settings for current page
$seo_title = $site_name;
$seo_description = get_setting('site_tagline', 'Your Business Growth Partner');
$seo_keywords = '';

// Page-specific SEO
switch($current_page) {
    case 'index':
    case 'home':
        $seo_title = 'Hostxolo - Business Growth Plan | All Services Under One Roof';
        $seo_description = 'Hostxolo provides business consulting, digital marketing, software solutions and more. Join 250+ satisfied customers. One plan for all your business needs.';
        break;
    case 'services':
        $seo_title = 'Our Services - Hostxolo Business Consulting';
        $seo_description = 'Explore our comprehensive business consulting services including development, digital marketing, automation, and cloud solutions.';
        break;
    case 'software':
        $seo_title = 'Software Products - Hostxolo';
        $seo_description = 'Discover our powerful software solutions: WhatsApp CRM, Cloud Telecalling, ERP, Marketing Automation, Website Builder, and AI Tools.';
        break;
    case 'plans':
    case 'packages':
        $seo_title = 'Business Growth Plans - Hostxolo Subscription Plans';
        $seo_description = 'Choose the perfect business growth plan for your needs. Monthly and yearly subscription options available.';
        break;
    case 'blog':
        $seo_title = 'Blog - Business Growth Tips & Insights | Hostxolo';
        $seo_description = 'Read our latest articles on business growth, digital marketing strategies, technology insights, and success stories.';
        break;
    case 'contact':
        $seo_title = 'Contact Us - Hostxolo Business Consulting';
        $seo_description = 'Contact Hostxolo for business consulting services. We are here to help your business grow digitally.';
        break;
    case 'about':
        $seo_title = 'About Us - Hostxolo Business Consulting';
        $seo_description = 'Learn about Hostxolo - your trusted partner for business growth consulting and digital transformation services.';
        break;
}

// Check if specific page SEO exists in database
try {
    $stmt = db()->prepare("SELECT meta_title, meta_description, meta_keywords FROM seo_settings WHERE page_type = ? AND (page_id = 0 OR page_id IS NULL)");
    $stmt->execute([$current_page]);
    $seo = $stmt->fetch();
    if ($seo) {
        if (!empty($seo['meta_title'])) $seo_title = $seo['meta_title'];
        if (!empty($seo['meta_description'])) $seo_description = $seo['meta_description'];
        if (!empty($seo['meta_keywords'])) $seo_keywords = $seo['meta_keywords'];
    }
} catch (PDOException $e) {
    // Silently continue with defaults
}

// Check for custom page SEO (if viewing a CMS page)
if (isset($page_slug)) {
    try {
        $stmt = db()->prepare("SELECT meta_title, meta_description FROM pages WHERE slug = ?");
        $stmt->execute([$page_slug]);
        $page_seo = $stmt->fetch();
        if ($page_seo) {
            if (!empty($page_seo['meta_title'])) $seo_title = $page_seo['meta_title'];
            if (!empty($page_seo['meta_description'])) $seo_description = $page_seo['meta_description'];
        }
    } catch (PDOException $e) {
        // Silently continue
    }
}

// Get cart count if user is logged in
$cart_count = 0;
if (is_logged_in()) {
    try {
        $stmt = db()->prepare("SELECT COUNT(*) as count FROM user_subscriptions WHERE user_id = ? AND status = 'pending'");
        $stmt->execute([$_SESSION['user_id']]);
        $cart = $stmt->fetch();
        $cart_count = $cart ? $cart['count'] : 0;
    } catch (PDOException $e) {
        // Silently continue
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <meta name="apple-mobile-web-app-title" content="Hostxolo">
    <meta name="description" content="<?php echo sanitize($seo_description); ?>">
    <meta name="keywords" content="<?php echo sanitize($seo_keywords); ?>">
    <meta name="author" content="Hostxolo">
    <meta name="robots" content="index, follow">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo BASE_URL; ?>">
    <meta property="og:title" content="<?php echo sanitize($seo_title); ?>">
    <meta property="og:description" content="<?php echo sanitize($seo_description); ?>">
    <meta property="og:image" content="<?php echo ASSETS_URL; ?>images/og-image.png">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="<?php echo BASE_URL; ?>">
    <meta property="twitter:title" content="<?php echo sanitize($seo_title); ?>">
    <meta property="twitter:description" content="<?php echo sanitize($seo_description); ?>">
    <meta property="twitter:image" content="<?php echo ASSETS_URL; ?>images/og-image.png">

    <title><?php echo sanitize($seo_title); ?></title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo ASSETS_URL; ?>images/favicon.ico">
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <!-- Custom CSS -->
    <link rel="stylesheet" href="<?php echo ASSETS_URL; ?>css/style.css">
    
    <!-- Orange Theme Override -->
    <link rel="stylesheet" href="<?php echo ASSETS_URL; ?>css/orange-theme.css">
    
    <!-- Mobile Responsive Styles -->
    <link rel="stylesheet" href="<?php echo ASSETS_URL; ?>css/mobile-responsive.css">
    
    <?php if (isset($extra_css)): ?>
        <?php echo $extra_css; ?>
    <?php endif; ?>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-light bg-white fixed-top shadow-sm">
        <div class="container">
            <a class="navbar-brand fw-bold" href="<?php echo BASE_URL; ?>">
                <span class="text-primary">HOST</span><span class="text-dark">XOLO</span>
            </a>
            
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto align-items-center">
                    <li class="nav-item">
                        <a class="nav-link <?php echo $current_page == 'index' ? 'active' : ''; ?>" href="<?php echo BASE_URL; ?>">Home</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo $current_page == 'about' ? 'active' : ''; ?>" href="<?php echo BASE_URL; ?>about.php">About Us</a>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle <?php echo in_array($current_page, ['services', 'software']) ? 'active' : ''; ?>" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            Services
                        </a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="<?php echo BASE_URL; ?>services.php">All Services</a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item" href="<?php echo BASE_URL; ?>services.php?category=development">Development Services</a></li>
                            <li><a class="dropdown-item" href="<?php echo BASE_URL; ?>services.php?category=marketing">Digital Marketing</a></li>
                            <li><a class="dropdown-item" href="<?php echo BASE_URL; ?>services.php?category=automation">Business Automation</a></li>
                            <li><a class="dropdown-item" href="<?php echo BASE_URL; ?>services.php?category=cloud">Cloud Solutions</a></li>
                        </ul>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo $current_page == 'software' ? 'active' : ''; ?>" href="<?php echo BASE_URL; ?>software.php">Software</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo $current_page == 'plans' ? 'active' : ''; ?>" href="<?php echo BASE_URL; ?>plans.php">
                            <span class="badge bg-primary">Business Growth Plan</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo $current_page == 'blog' ? 'active' : ''; ?>" href="<?php echo BASE_URL; ?>blog.php">Blog</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo $current_page == 'contact' ? 'active' : ''; ?>" href="<?php echo BASE_URL; ?>contact.php">Contact</a>
                    </li>
                    
                    <?php if (is_logged_in()): ?>
                        <li class="nav-item dropdown ms-lg-3">
                            <a class="nav-link dropdown-toggle btn btn-outline-primary px-3" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="bi bi-person-circle me-1"></i> My Account
                            </a>
                            <ul class="dropdown-menu dropdown-menu-end">
                                <li><a class="dropdown-item" href="<?php echo BASE_URL; ?>user/dashboard.php"><i class="bi bi-speedometer2 me-2"></i>Dashboard</a></li>
                                <li><a class="dropdown-item" href="<?php echo BASE_URL; ?>user/subscriptions.php"><i class="bi bi-credit-card me-2"></i>My Subscriptions</a></li>
                                <li><a class="dropdown-item" href="<?php echo BASE_URL; ?>user/tickets.php"><i class="bi bi-headset me-2"></i>Support Tickets</a></li>
                                <li><a class="dropdown-item" href="<?php echo BASE_URL; ?>user/profile.php"><i class="bi bi-person me-2"></i>Profile</a></li>
                                <li><hr class="dropdown-divider"></li>
                                <li><a class="dropdown-item text-danger" href="<?php echo BASE_URL; ?>logout.php"><i class="bi bi-box-arrow-right me-2"></i>Logout</a></li>
                            </ul>
                        </li>
                    <?php else: ?>
                        <li class="nav-item ms-lg-3">
                            <a class="btn btn-primary" href="<?php echo BASE_URL; ?>login.php">Login</a>
                        </li>
                        <li class="nav-item ms-lg-2">
                            <a class="btn btn-outline-primary" href="<?php echo BASE_URL; ?>register.php">Register</a>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Flash Messages -->
    <div class="container mt-5 pt-4">
        <?php echo flash_message(); ?>
    </div>
