<?php
/**
 * Hostxolo - Homepage
 */
require_once 'config.php';

// Get homepage sections from system settings
$hero_title = get_system_setting('homepage_hero_title') ?? 'बिजनेस से जुड़ीं सभी Services के लिए एक ही प्लान, Business Growth Plan';
$hero_subtitle = get_system_setting('homepage_hero_subtitle') ?? 'हम आपके Business को Digitally Grow कराने में आपकी मदद करते हैं ..';
$hero_content = get_system_setting('homepage_hero_content') ?? 'Get all business services under one roof. No need to hire multiple service providers or employees. We provide complete business growth solutions.';
$hero_button_text = get_system_setting('homepage_hero_button_text') ?? 'GET APPOINTMENT';
$hero_button_link = get_system_setting('homepage_hero_button_link') ?? 'https://wa.me/916388758325?text=Hi..';
$hero_image = get_system_setting('homepage_hero_image') ?? '';
$services_title = get_system_setting('homepage_services_title') ?? 'All Business Solutions Under One Roof';
$services_subtitle = get_system_setting('services_subtitle') ?? 'No More Services, No More Employees';
$software_title = get_system_setting('homepage_software_title') ?? 'Powerful Software Solutions';
$software_content = get_system_setting('homepage_software_content') ?? 'Transform your business with our cutting-edge software products designed for modern enterprises.';
$cta_title = get_system_setting('homepage_cta_title') ?? 'Ready to Grow Your Business?';
$cta_subtitle = get_system_setting('homepage_cta_subtitle') ?? 'Join 250+ satisfied customers who trust Hostxolo';
$cta_content = get_system_setting('homepage_cta_text') ?? 'Start your business growth journey today with our comprehensive solutions.';
$cta_button_text = get_system_setting('homepage_cta_button_text') ?? 'Get Started';
$testimonials_title = get_system_setting('homepage_testimonials_title') ?? 'Customer Review';

// Get services
$services = [];
try {
    $stmt = db()->query("SELECT s.*, sc.name as category_name, sc.slug as category_slug 
                        FROM services s 
                        LEFT JOIN service_categories sc ON s.category_id = sc.id 
                        WHERE s.status = 1 
                        ORDER BY s.sort_order 
                        LIMIT 6");
    $services = $stmt->fetchAll();
} catch (PDOException $e) {
    // Continue with empty services
}

// Get software products
$software = [];
try {
    $stmt = db()->query("SELECT * FROM software_products WHERE status = 1 ORDER BY sort_order LIMIT 6");
    $software = $stmt->fetchAll();
} catch (PDOException $e) {
    // Continue with empty software
}

// Get pricing plans
$plans = [];
try {
    $stmt = db()->query("SELECT * FROM subscription_plans WHERE status = 1 ORDER BY sort_order");
    $plans = $stmt->fetchAll();
} catch (PDOException $e) {
    // Continue with empty plans
}

// Get testimonials
$testimonials = [];
try {
    $stmt = db()->query("SELECT * FROM testimonials WHERE status = 1 ORDER BY sort_order");
    $testimonials = $stmt->fetchAll();
} catch (PDOException $e) {
    // Continue with empty testimonials
}

include 'includes/header.php';
?>

<!-- Hero Section -->
<section class="hero-section">
    <div class="container">
        <div class="row align-items-center min-vh-75">
            <div class="col-lg-7">
                <h1 class="hero-title">
                    <?php echo $hero_title; ?>
                </h1>
                <p class="hero-subtitle">
                    <?php echo $hero_subtitle; ?>
                </p>
                <p class="text-muted mb-4">
                    <?php echo $hero_content; ?>
                </p>
                <div class="hero-buttons">
                    <a href="<?php echo $hero_button_link; ?>" class="btn btn-primary btn-lg" target="_blank">
                        <i class="bi bi-calendar-check me-2"></i><?php echo $hero_button_text; ?>
                    </a>
                    <a href="<?php echo BASE_URL; ?>plans.php" class="btn btn-outline-primary btn-lg">
                        <i class="bi bi-credit-card me-2"></i>See Plans
                    </a>
                </div>
            </div>
            <div class="col-lg-5 text-center d-none d-lg-block">
                <div class="hero-image">
                    <?php if ($hero_image): ?>
                        <img src="<?php echo UPLOADS_URL . $hero_image; ?>" alt="Business Growth" class="img-fluid" style="max-height: 400px;">
                    <?php else: ?>
                        <img src="<?php echo ASSETS_URL; ?>images/hero-illustration.svg" alt="Business Growth" class="img-fluid" style="max-height: 400px;">
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Stats Section -->
<section class="stats-section py-5">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-6 col-md-3">
                <div class="stat-item">
                    <span class="stat-number counter" data-target="250">0</span>
                    <span class="stat-label">Regular Customers</span>
                </div>
            </div>
            <div class="col-6 col-md-3">
                <div class="stat-item">
                    <span class="stat-number counter" data-target="10">0</span>
                    <span class="stat-label">Countries</span>
                </div>
            </div>
            <div class="col-6 col-md-3">
                <div class="stat-item">
                    <span class="stat-number counter" data-target="7">0</span>
                    <span class="stat-label">Years Experience</span>
                </div>
            </div>
            <div class="col-6 col-md-3">
                <div class="stat-item">
                    <span class="stat-number counter" data-target="480">0</span>
                    <span class="stat-label">Projects Completed</span>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Services Section -->
<section class="services-section" id="services">
    <div class="container">
        <h2 class="section-title"><?php echo $services_title; ?></h2>
        <p class="section-subtitle"><?php echo $services_subtitle; ?></p>
        
        <div class="row g-4">
            <?php foreach ($services as $service): ?>
            <div class="col-md-6 col-lg-4">
                <div class="service-card">
                    <div class="service-icon">
                        <i class="bi <?php echo $service['icon'] ?? 'bi-briefcase'; ?>"></i>
                    </div>
                    <h3><?php echo $service['name']; ?></h3>
                    <p><?php echo $service['short_description']; ?></p>
                    <?php if ($service['price_starting_from']): ?>
                        <p class="text-primary fw-bold">Starting from <?php echo format_currency($service['price_starting_from']); ?></p>
                    <?php endif; ?>
                    <a href="<?php echo BASE_URL; ?>service.php?slug=<?php echo $service['slug']; ?>" class="btn btn-outline-primary btn-sm">
                        Learn More <i class="bi bi-arrow-right ms-1"></i>
                    </a>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        
        <div class="text-center mt-5">
            <a href="<?php echo BASE_URL; ?>services.php" class="btn btn-primary btn-lg">
                View All Services <i class="bi bi-arrow-right ms-2"></i>
            </a>
        </div>
    </div>
</section>

<!-- Software Section -->
<section class="software-section" id="software">
    <div class="container">
        <h2 class="section-title"><?php echo $software_title; ?></h2>
        <p class="section-subtitle"><?php echo $software_content; ?></p>
        
        <div class="row g-4">
            <?php foreach ($software as $item): ?>
            <div class="col-md-6 col-lg-4">
                <div class="software-card">
                    <div class="software-header">
                        <i class="bi <?php echo $item['icon'] ?? 'bi-box'; ?>"></i>
                        <h4><?php echo $item['name']; ?></h4>
                    </div>
                    <div class="software-body">
                        <p><?php echo $item['short_description']; ?></p>
                        <div class="d-flex justify-content-between align-items-center">
                            <span class="software-price">
                                <?php if ($item['pricing_type'] == 'free'): ?>
                                    Free
                                <?php elseif ($item['pricing_type'] == 'contact'): ?>
                                    Contact Us
                                <?php else: ?>
                                    <?php echo format_currency($item['price'] ?? 0); ?><small>/mo</small>
                                <?php endif; ?>
                            </span>
                            <a href="<?php echo BASE_URL; ?>software-detail.php?slug=<?php echo $item['slug']; ?>" class="btn btn-primary btn-sm">
                                Explore <i class="bi bi-arrow-right ms-1"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        
        <div class="text-center mt-5">
            <a href="<?php echo BASE_URL; ?>software.php" class="btn btn-outline-primary btn-lg">
                View All Software <i class="bi bi-grid ms-2"></i>
            </a>
        </div>
    </div>
</section>

<!-- Pricing Section -->
<section class="pricing-section" id="plans">
    <div class="container">
        <h2 class="section-title">Business Growth Plans</h2>
        <p class="section-subtitle">Choose the perfect plan for your business needs</p>
        
        <!-- Plan Toggle -->
        <div class="text-center mb-5">
            <div class="form-check form-switch d-inline-flex align-items-center gap-3">
                <span class="fw-medium">Monthly</span>
                <input class="form-check-input" type="checkbox" id="planToggle" style="width: 50px; height: 25px;">
                <span class="fw-medium">Yearly <span class="badge bg-success">Save 20%</span></span>
            </div>
        </div>
        
        <div class="row g-4 justify-content-center">
            <?php foreach ($plans as $plan): ?>
            <div class="col-md-4">
                <div class="pricing-card <?php echo $plan['is_featured'] ? 'featured' : ''; ?>">
                    <h3><?php echo $plan['name']; ?></h3>
                    <p class="text-muted"><?php echo $plan['description']; ?></p>
                    
                    <div class="price monthly-price">
                        <?php echo format_currency($plan['monthly_price']); ?><span>/month</span>
                    </div>
                    <div class="price yearly-price" style="display: none;">
                        <?php echo format_currency($plan['yearly_price']); ?><span>/year</span>
                    </div>
                    
                    <ul class="pricing-features">
                        <?php 
                        $features = json_decode($plan['features'] ?? '[]', true);
                        foreach ($features as $feature): 
                        ?>
                            <li><i class="bi bi-check-circle-fill"></i> <?php echo $feature; ?></li>
                        <?php endforeach; ?>
                    </ul>
                    
                    <a href="<?php echo BASE_URL; ?>subscribe.php?plan=<?php echo $plan['slug']; ?>" class="btn btn-primary w-100">
                        Get Started
                    </a>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<!-- Testimonials Section -->
<section class="testimonials-section" id="testimonials">
    <div class="container">
        <h2 class="section-title"><?php echo $testimonials_title; ?></h2>
        
        <div class="row g-4">
            <?php foreach ($testimonials as $testimonial): ?>
            <div class="col-md-4">
                <div class="testimonial-card">
                    <div class="testimonial-rating">
                        <?php for ($i = 0; $i < $testimonial['rating']; $i++): ?>
                            <i class="bi bi-star-fill"></i>
                        <?php endfor; ?>
                    </div>
                    <p class="testimonial-content">"<?php echo $testimonial['content']; ?>"</p>
                    <div class="testimonial-author">
                        <h5><?php echo $testimonial['name']; ?></h5>
                        <p><?php echo $testimonial['designation']; ?>, <?php echo $testimonial['company']; ?></p>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="cta-section" id="cta">
    <div class="container">
        <h2><?php echo $cta_title; ?></h2>
        <p><?php echo $cta_subtitle; ?></p>
        <p><?php echo $cta_content; ?></p>
        <a href="<?php echo BASE_URL; ?>plans.php" class="btn btn-light btn-lg mt-3">
            <?php echo $cta_button_text; ?> <i class="bi bi-arrow-right ms-2"></i>
        </a>
    </div>
</section>

<!-- WhatsApp Float Button -->
<a href="https://wa.me/916388758325?text=Hi.. I am interested in Hostxolo services" 
   class="btn btn-success position-fixed" 
   style="bottom: 30px; left: 30px; z-index: 1000; border-radius: 50px; padding: 12px 20px;"
   target="_blank">
    <i class="bi bi-whatsapp fs-5"></i> <span class="d-none d-sm-inline">Chat with Us</span>
</a>

<?php include 'includes/footer.php'; ?>
