<?php
/**
 * Hostxolo - Logout
 */
require_once 'config.php';

// Log the logout activity
if (is_logged_in() && isset($_SESSION['user_id'])) {
    log_activity('logout', 'User logged out', $_SESSION['user_id'], 'user');
}

// Clear all session data
$_SESSION = array();

// Destroy the session cookie
if (isset($_COOKIE[session_name()])) {
    setcookie(session_name(), '', time() - 3600, '/');
}

// Destroy the session
session_destroy();

// Clear remember me cookie
setcookie('remember_token', '', time() - 3600, '/');

// Redirect to homepage with message
redirect(BASE_URL, 'success', 'You have been logged out successfully.');
