<?php
/**
 * Hostxolo - CMS Page Template
 * Used for Privacy Policy, Terms, Refund, Disclaimer pages
 */
require_once 'config.php';

// Get page slug from URL
$page_slug = basename($_SERVER['PHP_SELF'], '.php');

// Default pages mapping
$page_mapping = [
    'privacy-policy' => 'Privacy Policy',
    'terms-conditions' => 'Terms & Conditions',
    'refund-cancellation' => 'Refund & Cancellation Policy',
    'disclaimer' => 'Disclaimer',
    'support' => 'Support / Help Desk'
];

// Get page content from database
$page = null;
try {
    $stmt = db()->prepare("SELECT * FROM pages WHERE slug = ? AND status = 1");
    $stmt->execute([$page_slug]);
    $page = $stmt->fetch();
} catch (PDOException $e) {
    // Continue without page data
}

// Set page title
$page_title = $page['title'] ?? ($page_mapping[$page_slug] ?? 'Page');

include 'includes/header.php';
?>

<!-- Page Header -->
<section class="page-header">
    <div class="container">
        <h1><?php echo $page_title; ?></h1>
        <p>Important information about our services</p>
    </div>
</section>

<!-- Page Content -->
<section class="py-5">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="card shadow border-0">
                    <div class="card-body p-4 p-md-5">
                        <?php if ($page && !empty($page['content'])): ?>
                            <div class="cms-content">
                                <?php echo $page['content']; ?>
                            </div>
                        <?php else: ?>
                            <div class="text-center py-5">
                                <i class="bi bi-file-earmark-text text-muted" style="font-size: 4rem;"></i>
                                <h4 class="mt-3">Content Coming Soon</h4>
                                <p class="text-muted">This page is under construction. Please check back later.</p>
                                <a href="<?php echo BASE_URL; ?>" class="btn btn-primary mt-2">
                                    <i class="bi bi-house me-2"></i>Back to Home
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>
