<?php
/**
 * Hostxolo - Payment Failed Page
 */
require_once 'config.php';

// Check if user is logged in, if not redirect to login with return URL
if (!isset($_SESSION['user_id'])) {
    $_SESSION['redirect_after_login'] = $_SERVER['REQUEST_URI'];
    redirect(BASE_URL . 'login.php');
}

$user_id = $_SESSION['user_id'];
$txn_id = sanitize($_GET['txn'] ?? '');
$reason = sanitize($_GET['reason'] ?? '');

// Set specific error messages based on reason
switch ($reason) {
    case 'cancelled':
        $error_message = 'Payment was cancelled. You can try again anytime.';
        break;
    case 'timeout':
        $error_message = 'Payment session expired. Please try again.';
        break;
    case 'failed':
        $error_message = 'Payment processing failed. Please check your payment details and try again.';
        break;
    default:
        $error_message = $_SESSION['flash_error'] ?? 'Your payment could not be processed. Please try again.';
}

// Log the failed payment attempt for debugging
error_log("Payment failed for transaction: $txn_id, User: $user_id, Error: $error_message");

$page_title = 'Payment Failed';
include 'includes/header.php';
?>

<section class="py-5" style="margin-top: 70px;">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6 text-center">
                <div class="mb-4">
                    <i class="bi bi-x-circle-fill text-danger" style="font-size: 5rem;"></i>
                </div>
                <h2 class="fw-bold mb-3">Payment Failed</h2>
                <p class="text-muted mb-4"><?php echo $error_message; ?></p>
                
                <?php if (!empty($txn_id)): ?>
                <div class="alert alert-light border mb-4">
                    <h6 class="fw-bold mb-2">Transaction Details:</h6>
                    <p class="mb-1"><strong>Transaction ID:</strong> <?php echo $txn_id; ?></p>
                    <?php if (!empty($reason)): ?>
                    <p class="mb-1"><strong>Reason:</strong> <?php echo ucfirst($reason); ?></p>
                    <?php endif; ?>
                    <p class="mb-0 text-muted small">This transaction ID has been logged for support purposes.</p>
                </div>
                <?php endif; ?>
                
                <div class="d-grid gap-2 d-md-flex justify-content-md-center">
                    <a href="<?php echo BASE_URL; ?>plans.php" class="btn btn-primary btn-lg">
                        <i class="bi bi-arrow-repeat me-2"></i>Try Again
                    </a>
                    <a href="<?php echo BASE_URL; ?>user/dashboard.php" class="btn btn-outline-secondary btn-lg">
                        <i class="bi bi-house me-2"></i>Dashboard
                    </a>
                    <a href="<?php echo BASE_URL; ?>contact.php" class="btn btn-outline-secondary btn-lg">
                        <i class="bi bi-headset me-2"></i>Contact Support
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>
