<?php
/**
 * Hostxolo - Payment Success Page
 */
require_once 'config.php';
require_login();

$subscription_id = intval($_GET['subscription'] ?? 0);
$txn_id = sanitize($_GET['txn'] ?? '');

if (!$subscription_id || empty($txn_id)) {
    redirect(BASE_URL . 'user/dashboard.php');
}

// Get subscription details
$subscription = null;
try {
    $stmt = db()->prepare("
        SELECT us.*, sp.name as plan_name, sp.duration_months
        FROM user_subscriptions us
        JOIN subscription_plans sp ON us.plan_id = sp.id
        WHERE us.id = ? AND us.user_id = ?
    ");
    $stmt->execute([$subscription_id, $_SESSION['user_id']]);
    $subscription = $stmt->fetch();
} catch (PDOException $e) {
    error_log("Payment success page error: " . $e->getMessage());
}

$page_title = 'Payment Successful';
include 'includes/header.php';
?>

<section class="py-5" style="margin-top: 70px;">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6 text-center">
                <div class="mb-4">
                    <i class="bi bi-check-circle-fill text-success" style="font-size: 5rem;"></i>
                </div>
                <h2 class="fw-bold mb-3">Payment Successful!</h2>
                <p class="text-muted mb-4">Thank you for your payment. Your subscription is now active.</p>
                
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-body">
                        <h5 class="fw-bold">Transaction Details</h5>
                        <hr>
                        <div class="row text-start">
                            <div class="col-6 text-muted">Transaction ID:</div>
                            <div class="col-6 fw-medium"><?php echo $txn_id; ?></div>
                            
                            <div class="col-6 text-muted mt-2">Plan:</div>
                            <div class="col-6 fw-medium mt-2"><?php echo $subscription['plan_name'] ?? 'N/A'; ?></div>
                            
                            <div class="col-6 text-muted mt-2">Amount:</div>
                            <div class="col-6 fw-medium mt-2"><?php echo $subscription ? format_currency($subscription['amount']) : '-'; ?></div>
                            
                            <div class="col-6 text-muted mt-2">Status:</div>
                            <div class="col-6 mt-2"><span class="badge bg-success">Paid</span></div>
                        </div>
                    </div>
                </div>
                
                <div class="d-grid gap-2 d-md-flex justify-content-md-center">
                    <a href="<?php echo BASE_URL; ?>user/dashboard.php" class="btn btn-primary btn-lg">
                        <i class="bi bi-speedometer2 me-2"></i>Go to Dashboard
                    </a>
                    <a href="<?php echo BASE_URL; ?>user/invoice.php?id=<?php echo $subscription_id; ?>" class="btn btn-outline-success btn-lg">
                        <i class="bi bi-receipt me-2"></i>Download Invoice
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>
