<?php
/**
 * Hostxolo - Business Growth Plans Page
 */
require_once 'config.php';

// Get all active plans
$plans = [];
try {
    $stmt = db()->query("SELECT * FROM subscription_plans WHERE status = 1 ORDER BY sort_order");
    $plans = $stmt->fetchAll();
} catch (PDOException $e) {
    // Continue with empty plans
}

// FAQ data
$faqs = [
    [
        'question' => 'What is included in the Business Growth Plan?',
        'answer' => 'Our Business Growth Plan includes access to all our software products, priority support, marketing tools, and consulting services. Each plan tier offers different levels of access and features.'
    ],
    [
        'question' => 'Can I upgrade or downgrade my plan?',
        'answer' => 'Yes, you can upgrade or downgrade your plan at any time. Upgrades take effect immediately, while downgrades take effect at the end of your current billing cycle.'
    ],
    [
        'question' => 'Is there a free trial available?',
        'answer' => 'Yes! We offer a 7-day free trial for our Basic Growth Plan. You can explore all features before committing to a paid subscription.'
    ],
    [
        'question' => 'What payment methods do you accept?',
        'answer' => 'We accept all major credit cards, debit cards, UPI, net banking, and digital wallets. All payments are processed securely through Razorpay or Stripe.'
    ],
    [
        'question' => 'Can I cancel my subscription anytime?',
        'answer' => 'Absolutely! You can cancel your subscription at any time from your dashboard. Your access will continue until the end of your current billing period.'
    ],
    [
        'question' => 'Do you offer refunds?',
        'answer' => 'We offer a 7-day money-back guarantee for new subscriptions. If you are not satisfied with our services, contact our support team for a full refund.'
    ]
];

include 'includes/header.php';
?>

<!-- Page Header -->
<section class="page-header">
    <div class="container">
        <h1>Business Growth Plans</h1>
        <p>Choose the perfect plan to accelerate your business growth</p>
    </div>
</section>

<!-- Pricing Section -->
<section class="py-5">
    <div class="container">
        <!-- Plan Toggle -->
        <div class="text-center mb-5">
            <div class="form-check form-switch d-inline-flex align-items-center gap-3">
                <span class="fw-medium <?php echo empty($_GET['billing']) || $_GET['billing'] === 'monthly' ? 'text-primary' : 'text-muted'; ?>">Monthly</span>
                <input class="form-check-input" type="checkbox" id="planToggle" style="width: 50px; height: 25px;" 
                       <?php echo isset($_GET['billing']) && $_GET['billing'] === 'yearly' ? 'checked' : ''; ?>>
                <span class="fw-medium <?php echo isset($_GET['billing']) && $_GET['billing'] === 'yearly' ? 'text-primary' : 'text-muted'; ?>">Yearly</span>
                <span class="badge bg-success">Save 20%</span>
            </div>
        </div>
        
        <!-- Pricing Cards -->
        <div class="row g-4 justify-content-center">
            <?php foreach ($plans as $plan): ?>
            <div class="col-md-4">
                <div class="card h-100 pricing-card <?php echo $plan['is_featured'] ? 'featured' : 'border-0 shadow-sm'; ?>">
                    <div class="card-body p-4 p-md-5 text-center">
                        <?php if ($plan['is_featured']): ?>
                            <span class="badge bg-primary position-absolute" style="top: -10px; left: 50%; transform: translateX(-50%);">
                                Most Popular
                            </span>
                        <?php endif; ?>
                        
                        <h4 class="fw-bold mb-2"><?php echo $plan['name']; ?></h4>
                        <p class="text-muted small mb-4"><?php echo $plan['description']; ?></p>
                        
                        <div class="mb-4">
                            <span class="display-4 fw-bold text-primary monthly-price">
                                <?php echo format_currency($plan['monthly_price']); ?>
                            </span>
                            <span class="display-4 fw-bold text-primary yearly-price" style="display: none;">
                                <?php echo format_currency($plan['yearly_price']); ?>
                            </span>
                            <span class="text-muted">/<span class="billing-period">month</span></span>
                        </div>
                        
                        <ul class="list-unstyled text-start mb-4">
                            <?php 
                            $features = json_decode($plan['features'] ?? '[]', true);
                            foreach ($features as $feature): 
                            ?>
                                <li class="mb-2">
                                    <i class="bi bi-check-circle-fill text-success me-2"></i>
                                    <?php echo $feature; ?>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                        
                        <a href="<?php echo BASE_URL; ?>subscribe.php?plan=<?php echo $plan['slug']; ?>&billing=monthly" 
                           class="btn <?php echo $plan['is_featured'] ? 'btn-primary' : 'btn-outline-primary'; ?> w-100 btn-lg monthly-btn">
                            Get Started
                        </a>
                        <a href="<?php echo BASE_URL; ?>subscribe.php?plan=<?php echo $plan['slug']; ?>&billing=yearly" 
                           class="btn <?php echo $plan['is_featured'] ? 'btn-primary' : 'btn-outline-primary'; ?> w-100 btn-lg yearly-btn" style="display: none;">
                            Get Started (Yearly)
                        </a>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        
        <!-- Money Back Guarantee -->
        <div class="text-center mt-5">
            <p class="text-muted">
                <i class="bi bi-shield-check text-success me-2"></i>
                7-Day Money Back Guarantee - Cancel Anytime
            </p>
        </div>
    </div>
</section>

<!-- FAQ Section -->
<section class="py-5">
    <div class="container">
        <h2 class="section-title">Frequently Asked Questions</h2>
        <p class="section-subtitle">Got questions? We have answers</p>
        
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="accordion" id="faqAccordion">
                    <?php foreach ($faqs as $index => $faq): ?>
                    <div class="accordion-item border-0 mb-2 shadow-sm">
                        <h2 class="accordion-header">
                            <button class="accordion-button <?php echo $index > 0 ? 'collapsed' : ''; ?>" type="button" 
                                    data-bs-toggle="collapse" data-bs-target="#faq<?php echo $index; ?>">
                                <?php echo $faq['question']; ?>
                            </button>
                        </h2>
                        <div id="faq<?php echo $index; ?>" class="accordion-collapse collapse <?php echo $index === 0 ? 'show' : ''; ?>" 
                             data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                <?php echo $faq['answer']; ?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
</section>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const planToggle = document.getElementById('planToggle');
    const monthlyPrices = document.querySelectorAll('.monthly-price');
    const yearlyPrices = document.querySelectorAll('.yearly-price');
    const monthlyBtns = document.querySelectorAll('.monthly-btn');
    const yearlyBtns = document.querySelectorAll('.yearly-btn');
    const billingPeriods = document.querySelectorAll('.billing-period');
    
    planToggle.addEventListener('change', function() {
        if (this.checked) {
            monthlyPrices.forEach(el => el.style.display = 'none');
            yearlyPrices.forEach(el => el.style.display = 'inline');
            monthlyBtns.forEach(el => el.style.display = 'none');
            yearlyBtns.forEach(el => el.style.display = 'block');
            billingPeriods.forEach(el => el.textContent = 'year');
        } else {
            monthlyPrices.forEach(el => el.style.display = 'inline');
            yearlyPrices.forEach(el => el.style.display = 'none');
            monthlyBtns.forEach(el => el.style.display = 'block');
            yearlyBtns.forEach(el => el.style.display = 'none');
            billingPeriods.forEach(el => el.textContent = 'month');
        }
    });
});
</script>

<?php include 'includes/footer.php'; ?>
