<?php
/**
 * Hostxolo - Services Page
 */
require_once 'config.php';

// Get all service categories
$categories = [];
try {
    $stmt = db()->query("SELECT * FROM service_categories WHERE status = 1 ORDER BY sort_order");
    $categories = $stmt->fetchAll();
} catch (PDOException $e) {
    // Continue with empty categories
}

// Get all services
$category_filter = $_GET['category'] ?? '';
$sql = "SELECT s.*, sc.name as category_name, sc.slug as category_slug 
        FROM services s 
        LEFT JOIN service_categories sc ON s.category_id = sc.id 
        WHERE s.status = 1";

$params = [];
if (!empty($category_filter)) {
    $sql .= " AND sc.slug = ?";
    $params[] = $category_filter;
}

$sql .= " ORDER BY s.sort_order";

try {
    $stmt = db()->prepare($sql);
    $stmt->execute($params);
    $services = $stmt->fetchAll();
} catch (PDOException $e) {
    $services = [];
}

include 'includes/header.php';
?>

<!-- Page Header -->
<section class="page-header">
    <div class="container">
        <h1>Our Services</h1>
        <p>Comprehensive business solutions to help your business grow</p>
    </div>
</section>

<!-- Services Section -->
<section class="py-5">
    <div class="container">
        <!-- Category Filter -->
        <div class="row mb-4">
            <div class="col-12 text-center">
                <div class="btn-group flex-wrap" role="group">
                    <a href="<?php echo BASE_URL; ?>services.php" 
                       class="btn btn-outline-primary <?php echo empty($category_filter) ? 'active' : ''; ?>">
                        All Services
                    </a>
                    <?php foreach ($categories as $cat): ?>
                        <a href="<?php echo BASE_URL; ?>services.php?category=<?php echo $cat['slug']; ?>" 
                           class="btn btn-outline-primary <?php echo $category_filter === $cat['slug'] ? 'active' : ''; ?>">
                            <?php echo $cat['name']; ?>
                        </a>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        
        <!-- Services Grid -->
        <div class="row g-4">
            <?php if (empty($services)): ?>
                <div class="col-12 text-center py-5">
                    <i class="bi bi-inbox text-muted" style="font-size: 4rem;"></i>
                    <p class="text-muted mt-3">No services found in this category.</p>
                </div>
            <?php else: ?>
                <?php foreach ($services as $service): ?>
                <div class="col-md-6 col-lg-4">
                    <div class="card h-100 service-card border-0 shadow-sm">
                        <div class="card-body p-4">
                            <div class="service-icon mb-3">
                                <i class="bi <?php echo $service['icon'] ?? 'bi-briefcase'; ?>"></i>
                            </div>
                            <h4 class="card-title"><?php echo $service['name']; ?></h4>
                            <p class="text-muted small mb-2">
                                <i class="bi bi-folder me-1"></i> <?php echo $service['category_name'] ?? 'General'; ?>
                            </p>
                            <p class="card-text text-muted"><?php echo $service['short_description']; ?></p>
                            
                            <?php if ($service['price_starting_from']): ?>
                                <p class="text-primary fw-bold">Starting from <?php echo format_currency($service['price_starting_from']); ?></p>
                            <?php endif; ?>
                            
                            <?php if (!empty($service['features'])): 
                                $features = json_decode($service['features'], true);
                                if ($features): ?>
                                <ul class="list-unstyled mb-3">
                                    <?php foreach (array_slice($features, 0, 3) as $feature): ?>
                                        <li class="small text-muted"><i class="bi bi-check-circle-fill text-success me-2"></i><?php echo $feature; ?></li>
                                    <?php endforeach; ?>
                                </ul>
                            <?php endif; endif; ?>
                            
                            <?php 
                            $btn_text = $service['button_text'] ?? 'Learn More';
                            $btn_link = !empty($service['button_link']) ? $service['button_link'] : BASE_URL . 'service.php?slug=' . $service['slug'];
                            // Handle external vs internal links
                            if (strpos($btn_link, 'http') !== 0 && strpos($btn_link, '/') !== 0) {
                                $btn_link = BASE_URL . $btn_link;
                            }
                            ?>
                            <a href="<?php echo $btn_link; ?>" class="btn btn-primary w-100">
                                <?php echo $btn_text; ?> <i class="bi bi-arrow-right ms-1"></i>
                            </a>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="cta-section py-5">
    <div class="container text-center">
        <h2 class="mb-3">Need a Custom Solution?</h2>
        <p class="mb-4">Contact us for tailored business solutions that meet your specific requirements.</p>
        <a href="<?php echo BASE_URL; ?>contact.php" class="btn btn-light btn-lg">
            <i class="bi bi-chat-dots me-2"></i>Contact Us
        </a>
    </div>
</section>

<?php include 'includes/footer.php'; ?>
