<?php
/**
 * Hostxolo - Dynamic XML Sitemap Generator
 */
require_once 'config.php';

header('Content-Type: application/xml; charset=utf-8');

echo '<?xml version="1.0" encoding="UTF-8"?>';
?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
    <!-- Static Pages -->
    <url>
        <loc><?php echo BASE_URL; ?></loc>
        <changefreq>daily</changefreq>
        <priority>1.0</priority>
    </url>
    <url>
        <loc><?php echo BASE_URL; ?>about.php</loc>
        <changefreq>weekly</changefreq>
        <priority>0.8</priority>
    </url>
    <url>
        <loc><?php echo BASE_URL; ?>services.php</loc>
        <changefreq>weekly</changefreq>
        <priority>0.8</priority>
    </url>
    <url>
        <loc><?php echo BASE_URL; ?>software.php</loc>
        <changefreq>weekly</changefreq>
        <priority>0.8</priority>
    </url>
    <url>
        <loc><?php echo BASE_URL; ?>plans.php</loc>
        <changefreq>weekly</changefreq>
        <priority>0.9</priority>
    </url>
    <url>
        <loc><?php echo BASE_URL; ?>blog.php</loc>
        <changefreq>daily</changefreq>
        <priority>0.7</priority>
    </url>
    <url>
        <loc><?php echo BASE_URL; ?>contact.php</loc>
        <changefreq>monthly</changefreq>
        <priority>0.6</priority>
    </url>
    
    <?php
    // Services
    try {
        $stmt = db()->query("SELECT slug, updated_at FROM services WHERE status = 1");
        while ($row = $stmt->fetch()):
    ?>
    <url>
        <loc><?php echo BASE_URL; ?>service.php?slug=<?php echo $row['slug']; ?></loc>
        <lastmod><?php echo date('Y-m-d', strtotime($row['updated_at'])); ?></lastmod>
        <changefreq>weekly</changefreq>
        <priority>0.6</priority>
    </url>
    <?php 
        endwhile;
    } catch (PDOException $e) {}
    ?>
    
    <?php
    // Software Products
    try {
        $stmt = db()->query("SELECT slug, updated_at FROM software_products WHERE status = 1");
        while ($row = $stmt->fetch()):
    ?>
    <url>
        <loc><?php echo BASE_URL; ?>software-detail.php?slug=<?php echo $row['slug']; ?></loc>
        <lastmod><?php echo date('Y-m-d', strtotime($row['updated_at'])); ?></lastmod>
        <changefreq>weekly</changefreq>
        <priority>0.6</priority>
    </url>
    <?php 
        endwhile;
    } catch (PDOException $e) {}
    ?>
    
    <?php
    // Blog Posts
    try {
        $stmt = db()->query("SELECT slug, updated_at FROM blog_posts WHERE status = 'published'");
        while ($row = $stmt->fetch()):
    ?>
    <url>
        <loc><?php echo BASE_URL; ?>blog-post.php?slug=<?php echo $row['slug']; ?></loc>
        <lastmod><?php echo date('Y-m-d', strtotime($row['updated_at'])); ?></lastmod>
        <changefreq>monthly</changefreq>
        <priority>0.5</priority>
    </url>
    <?php 
        endwhile;
    } catch (PDOException $e) {}
    ?>
    
    <?php
    // CMS Pages
    try {
        $stmt = db()->query("SELECT slug, updated_at FROM pages WHERE status = 1");
        while ($row = $stmt->fetch()):
    ?>
    <url>
        <loc><?php echo BASE_URL; ?><?php echo $row['slug']; ?>.php</loc>
        <lastmod><?php echo date('Y-m-d', strtotime($row['updated_at'])); ?></lastmod>
        <changefreq>monthly</changefreq>
        <priority>0.4</priority>
    </url>
    <?php 
        endwhile;
    } catch (PDOException $e) {}
    ?>
</urlset>
