<?php
/**
 * Hostxolo - Software Products Page
 */
require_once 'config.php';

// Get all software categories
$categories = [
    'crm' => 'CRM Software',
    'telecalling' => 'Telecalling',
    'erp' => 'ERP Software',
    'marketing' => 'Marketing Tools',
    'website_builder' => 'Website Builder',
    'ai_engine' => 'AI Solutions',
    'other' => 'Other Software'
];

// Get category filter
$category_filter = $_GET['category'] ?? '';

// Build query
$sql = "SELECT * FROM software_products WHERE status = 1";
$params = [];

if (!empty($category_filter)) {
    $sql .= " AND category = ?";
    $params[] = $category_filter;
}

$sql .= " ORDER BY sort_order";

try {
    $stmt = db()->prepare($sql);
    $stmt->execute($params);
    $software = $stmt->fetchAll();
} catch (PDOException $e) {
    $software = [];
}

include 'includes/header.php';
?>

<!-- Page Header -->
<section class="page-header">
    <div class="container">
        <h1>Software Products</h1>
        <p>Powerful software solutions to transform your business</p>
    </div>
</section>

<!-- Software Section -->
<section class="py-5">
    <div class="container">
        <!-- Category Filter -->
        <div class="row mb-4">
            <div class="col-12 text-center">
                <div class="btn-group flex-wrap" role="group">
                    <a href="<?php echo BASE_URL; ?>software.php" 
                       class="btn btn-outline-primary <?php echo empty($category_filter) ? 'active' : ''; ?>">
                        All Software
                    </a>
                    <?php foreach ($categories as $key => $name): ?>
                        <a href="<?php echo BASE_URL; ?>software.php?category=<?php echo $key; ?>" 
                           class="btn btn-outline-primary <?php echo $category_filter === $key ? 'active' : ''; ?>">
                            <?php echo $name; ?>
                        </a>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        
        <!-- Software Grid -->
        <div class="row g-4">
            <?php if (empty($software)): ?>
                <div class="col-12 text-center py-5">
                    <i class="bi bi-box text-muted" style="font-size: 4rem;"></i>
                    <p class="text-muted mt-3">No software found in this category.</p>
                </div>
            <?php else: ?>
                <?php foreach ($software as $item): ?>
                <div class="col-md-6 col-lg-4">
                    <div class="card h-100 software-card border-0 shadow-sm">
                        <div class="card-header bg-primary text-white text-center py-4 border-0">
                            <i class="bi <?php echo $item['icon'] ?? 'bi-box'; ?>" style="font-size: 3rem;"></i>
                            <h5 class="mt-2 mb-0"><?php echo $item['name']; ?></h5>
                            <small class="opacity-75"><?php echo $categories[$item['category']] ?? 'Software'; ?></small>
                        </div>
                        <div class="card-body p-4">
                            <p class="text-muted"><?php echo $item['short_description']; ?></p>
                            
                            <?php if (!empty($item['features'])): 
                                $features = json_decode($item['features'], true);
                                if ($features): ?>
                                <ul class="list-unstyled mb-3">
                                    <?php foreach (array_slice($features, 0, 4) as $feature): ?>
                                        <li class="small text-muted mb-1">
                                            <i class="bi bi-check-circle-fill text-success me-2"></i><?php echo $feature; ?>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            <?php endif; endif; ?>
                            
                            <div class="d-flex justify-content-between align-items-center mt-auto pt-3 border-top">
                                <span class="h5 mb-0 text-primary">
                                    <?php if ($item['pricing_type'] == 'free'): ?>
                                        Free
                                    <?php elseif ($item['pricing_type'] == 'contact'): ?>
                                        Contact Us
                                    <?php else: ?>
                                        <?php echo format_currency($item['price'] ?? 0); ?><small class="text-muted">/mo</small>
                                    <?php endif; ?>
                                </span>
                                <?php 
                                $btn_text = $item['button_text'] ?? 'Explore';
                                $btn_link = !empty($item['button_link']) ? $item['button_link'] : BASE_URL . 'software-detail.php?slug=' . $item['slug'];
                                if (strpos($btn_link, 'http') !== 0 && strpos($btn_link, '/') !== 0) {
                                    $btn_link = BASE_URL . $btn_link;
                                }
                                ?>
                                <a href="<?php echo $btn_link; ?>" class="btn btn-primary btn-sm">
                                    <?php echo $btn_text; ?> <i class="bi bi-arrow-right ms-1"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>
</section>

<!-- Features Section -->
<section class="py-5 bg-light">
    <div class="container">
        <div class="row g-4 text-center">
            <div class="col-md-3">
                <div class="p-4">
                    <i class="bi bi-cloud-check text-primary" style="font-size: 3rem;"></i>
                    <h5 class="mt-3">Cloud Based</h5>
                    <p class="text-muted small">Access from anywhere, anytime</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="p-4">
                    <i class="bi bi-shield-check text-primary" style="font-size: 3rem;"></i>
                    <h5 class="mt-3">Secure</h5>
                    <p class="text-muted small">Enterprise-grade security</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="p-4">
                    <i class="bi bi-headset text-primary" style="font-size: 3rem;"></i>
                    <h5 class="mt-3">24/7 Support</h5>
                    <p class="text-muted small">Always here to help you</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="p-4">
                    <i class="bi bi-arrow-repeat text-primary" style="font-size: 3rem;"></i>
                    <h5 class="mt-3">Auto Updates</h5>
                    <p class="text-muted small">Always stay up to date</p>
                </div>
            </div>
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>
