<?php
/**
 * Hostxolo - Enhanced Support Page
 */
require_once 'config.php';

$page_title = 'Support / Help Desk';

// Get FAQs from database if available
$faqs = [
    [
        'question' => 'How do I get started with Hostxolo?',
        'answer' => 'Simply create an account and choose a subscription plan that fits your needs. You can start with our Basic Growth Plan and upgrade anytime as your business grows.'
    ],
    [
        'question' => 'What payment methods do you accept?',
        'answer' => 'We accept all major credit cards, UPI, net banking, and digital wallets. All payments are processed securely through our payment gateways.'
    ],
    [
        'question' => 'How can I upgrade or downgrade my plan?',
        'answer' => 'You can upgrade or downgrade your plan at any time from your user dashboard. Go to "My Subscriptions" and click "Upgrade Plan" to see all available options.'
    ],
    [
        'question' => 'What is your refund policy?',
        'answer' => 'We offer a 7-day money-back guarantee for new subscriptions. If you are not satisfied with our services, contact us within 7 days for a full refund.'
    ],
    [
        'question' => 'How do I contact support?',
        'answer' => 'You can reach our support team via email at support@hostxolo.com, WhatsApp at +91-6388758325, or by creating a support ticket from your user dashboard.'
    ],
    [
        'question' => 'Are there any setup fees?',
        'answer' => 'No, there are no hidden setup fees. You only pay the subscription amount mentioned in your chosen plan.'
    ]
];

include 'includes/header.php';
?>

<style>
.support-hero {
    background: linear-gradient(135deg, #f97316 0%, #ea580c 50%, #c2410c 100%);
    padding: 4rem 0;
    position: relative;
    overflow: hidden;
}
.support-hero::before {
    content: '';
    position: absolute;
    top: -50%;
    right: -10%;
    width: 500px;
    height: 500px;
    background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
    border-radius: 50%;
}
.support-hero::after {
    content: '';
    position: absolute;
    bottom: -30%;
    left: -5%;
    width: 400px;
    height: 400px;
    background: radial-gradient(circle, rgba(255,255,255,0.08) 0%, transparent 70%);
    border-radius: 50%;
}
.contact-card {
    border: none;
    border-radius: 20px;
    transition: all 0.3s ease;
    background: white;
}
.contact-card:hover {
    transform: translateY(-8px);
    box-shadow: 0 20px 40px rgba(0,0,0,0.1) !important;
}
.contact-icon {
    width: 80px;
    height: 80px;
    border-radius: 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 2rem;
    margin-bottom: 1.5rem;
}
.faq-item {
    border: none;
    border-radius: 16px;
    margin-bottom: 1rem;
    background: white;
    box-shadow: 0 2px 10px rgba(0,0,0,0.05);
}
.faq-button {
    border-radius: 16px;
    padding: 1.25rem;
    font-weight: 600;
    color: #1f2937;
    background: white;
    border: none;
}
.faq-button:not(.collapsed) {
    background: #fff7ed;
    color: #f97316;
}
.faq-button:focus {
    box-shadow: none;
}
.faq-body {
    padding: 0 1.25rem 1.25rem;
    color: #6b7280;
}
.quick-link {
    display: flex;
    align-items: center;
    padding: 1rem 1.5rem;
    background: white;
    border-radius: 12px;
    text-decoration: none;
    color: #374151;
    transition: all 0.2s ease;
    border: 1px solid #e5e7eb;
}
.quick-link:hover {
    background: #fff7ed;
    border-color: #f97316;
    color: #f97316;
}
.support-badge {
    display: inline-flex;
    align-items: center;
    padding: 0.5rem 1rem;
    background: rgba(255,255,255,0.15);
    border-radius: 50px;
    color: white;
    font-size: 0.875rem;
}
</style>

<!-- Hero Section -->
<section class="support-hero text-white">
    <div class="container position-relative" style="z-index: 1;">
        <div class="row justify-content-center text-center">
            <div class="col-lg-8">
                <span class="support-badge mb-3">
                    <i class="bi bi-headset me-2"></i>24/7 Support Available
                </span>
                <h1 class="display-4 fw-bold mb-3">How Can We Help You?</h1>
                <p class="lead opacity-90 mb-4">Get instant answers or connect with our support team. We're here to help you succeed.</p>
                
                <!-- Quick Search -->
                <div class="row justify-content-center">
                    <div class="col-md-8">
                        <div class="input-group input-group-lg">
                            <span class="input-group-text bg-white border-0">
                                <i class="bi bi-search text-muted"></i>
                            </span>
                            <input type="text" class="form-control border-0" placeholder="Search for answers..." id="faqSearch">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Contact Methods -->
<section class="py-5" style="margin-top: -3rem;">
    <div class="container">
        <div class="row g-4">
            <!-- WhatsApp -->
            <div class="col-md-4">
                <div class="card contact-card shadow-sm h-100 text-center p-4">
                    <div class="contact-icon bg-success bg-opacity-10 text-success mx-auto">
                        <i class="bi bi-whatsapp"></i>
                    </div>
                    <h4 class="fw-bold mb-2">WhatsApp</h4>
                    <p class="text-muted mb-3">Get instant help via WhatsApp. Available 24/7 for quick queries.</p>
                    <a href="https://wa.me/916388758325" target="_blank" class="btn btn-success w-100">
                        <i class="bi bi-chat-dots me-2"></i>Chat Now
                    </a>
                    <small class="text-muted mt-2">+91-6388758325</small>
                </div>
            </div>
            
            <!-- Email -->
            <div class="col-md-4">
                <div class="card contact-card shadow-sm h-100 text-center p-4">
                    <div class="contact-icon bg-primary bg-opacity-10 text-primary mx-auto">
                        <i class="bi bi-envelope"></i>
                    </div>
                    <h4 class="fw-bold mb-2">Email Us</h4>
                    <p class="text-muted mb-3">Send us an email for detailed queries. We respond within 24 hours.</p>
                    <a href="mailto:support@hostxolo.com" class="btn btn-primary w-100">
                        <i class="bi bi-send me-2"></i>Send Email
                    </a>
                    <small class="text-muted mt-2">support@hostxolo.com</small>
                </div>
            </div>
            
            <!-- Ticket -->
            <div class="col-md-4">
                <div class="card contact-card shadow-sm h-100 text-center p-4">
                    <div class="contact-icon bg-warning bg-opacity-10 text-warning mx-auto">
                        <i class="bi bi-ticket"></i>
                    </div>
                    <h4 class="fw-bold mb-2">Support Ticket</h4>
                    <p class="text-muted mb-3">Create a ticket for complex issues. Track progress anytime.</p>
                    <a href="<?php echo BASE_URL; ?>user/create-ticket.php" class="btn btn-warning w-100">
                        <i class="bi bi-plus-circle me-2"></i>Create Ticket
                    </a>
                    <small class="text-muted mt-2">For registered users</small>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Quick Links -->
<section class="py-4 bg-light">
    <div class="container">
        <h3 class="text-center fw-bold mb-4">Quick Links</h3>
        <div class="row g-3 justify-content-center">
            <div class="col-md-3">
                <a href="<?php echo BASE_URL; ?>plans.php" class="quick-link">
                    <i class="bi bi-credit-card text-primary fs-4 me-3"></i>
                    <div>
                        <h6 class="mb-0">View Plans</h6>
                        <small class="text-muted">Browse subscriptions</small>
                    </div>
                    <i class="bi bi-chevron-right ms-auto text-muted"></i>
                </a>
            </div>
            <div class="col-md-3">
                <a href="<?php echo BASE_URL; ?>user/dashboard.php" class="quick-link">
                    <i class="bi bi-speedometer2 text-success fs-4 me-3"></i>
                    <div>
                        <h6 class="mb-0">User Dashboard</h6>
                        <small class="text-muted">Manage account</small>
                    </div>
                    <i class="bi bi-chevron-right ms-auto text-muted"></i>
                </a>
            </div>
            <div class="col-md-3">
                <a href="<?php echo BASE_URL; ?>privacy-policy.php" class="quick-link">
                    <i class="bi bi-shield-check text-info fs-4 me-3"></i>
                    <div>
                        <h6 class="mb-0">Privacy Policy</h6>
                        <small class="text-muted">Data protection</small>
                    </div>
                    <i class="bi bi-chevron-right ms-auto text-muted"></i>
                </a>
            </div>
            <div class="col-md-3">
                <a href="<?php echo BASE_URL; ?>refund-cancellation.php" class="quick-link">
                    <i class="bi bi-cash-stack text-warning fs-4 me-3"></i>
                    <div>
                        <h6 class="mb-0">Refund Policy</h6>
                        <small class="text-muted">Cancellation info</small>
                    </div>
                    <i class="bi bi-chevron-right ms-auto text-muted"></i>
                </a>
            </div>
        </div>
    </div>
</section>

<!-- FAQ Section -->
<section class="py-5">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="text-center mb-5">
                    <h3 class="fw-bold mb-2">Frequently Asked Questions</h3>
                    <p class="text-muted">Find quick answers to common questions</p>
                </div>
                
                <div class="accordion" id="faqAccordion">
                    <?php foreach ($faqs as $index => $faq): ?>
                    <div class="accordion-item faq-item" data-question="<?php echo strtolower($faq['question']); ?>">
                        <h2 class="accordion-header">
                            <button class="accordion-button faq-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq<?php echo $index; ?>">
                                <i class="bi bi-question-circle text-primary me-3"></i>
                                <?php echo $faq['question']; ?>
                            </button>
                        </h2>
                        <div id="faq<?php echo $index; ?>" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                            <div class="accordion-body faq-body">
                                <?php echo $faq['answer']; ?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
                
                <!-- More Help -->
                <div class="card border-0 shadow-sm mt-5 bg-primary text-white text-center">
                    <div class="card-body p-4">
                        <i class="bi bi-headset display-4 mb-3"></i>
                        <h4 class="fw-bold mb-2">Still Need Help?</h4>
                        <p class="opacity-90 mb-3">Our dedicated support team is always ready to assist you with any questions.</p>
                        <div class="d-flex justify-content-center gap-3">
                            <a href="https://wa.me/916388758325" target="_blank" class="btn btn-light">
                                <i class="bi bi-whatsapp me-2"></i>WhatsApp
                            </a>
                            <a href="mailto:support@hostxolo.com" class="btn btn-outline-light">
                                <i class="bi bi-envelope me-2"></i>Email Us
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Search Script -->
<script>
document.getElementById('faqSearch').addEventListener('input', function() {
    const searchTerm = this.value.toLowerCase();
    const faqItems = document.querySelectorAll('.faq-item');
    
    faqItems.forEach(item => {
        const question = item.getAttribute('data-question');
        if (question.includes(searchTerm)) {
            item.style.display = 'block';
        } else {
            item.style.display = 'none';
        }
    });
});
</script>

<?php include 'includes/footer.php'; ?>
